package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

public class FormContainer extends Composite implements INeptuneWidget {
	private static final String STYLE_CONTAINER_TABLE = "nwt-FormContainer-table";
	private static final String STYLE_LABEL_CELL = "nwt-FormContainer-label-cell";
	private static final String STYLE_VALUE_CELL = "nwt-FormContainer-value-cell";
	private static final String STYLE_REQUIRED = "nwt-FormContainer-required";
	private static final String STYLE_LABEL = "nwt-FormContainer-label";
	private static final String STYLE_VALUE = "nwt-FormContainer-value";
	private static final int MAINPANEL_SPACING = 10;

	private VerticalPanel mainPanel;
	private FlexTable formTable;
	private HorizontalPanel buttonPanel;

	public FormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant buttonPanelHAlign) {
		mainPanel = new VerticalPanel();
		mainPanel.setSpacing(MAINPANEL_SPACING);
		formTable = new FlexTable();
		formTable.setStyleName(STYLE_CONTAINER_TABLE);
		buttonPanel = new HorizontalPanel();

		mainPanel.add(formTable);
		mainPanel.setCellHorizontalAlignment(formTable, VerticalPanel.ALIGN_CENTER);

		mainPanel.add(buttonPanel);
		mainPanel.setCellHorizontalAlignment(buttonPanel, buttonPanelHAlign);

		initWidget(mainPanel);
	}

	public int addRow(LabelWidget label, Widget value, boolean markRequired) {
		label.addStyleName(STYLE_LABEL);
		value.addStyleName(STYLE_VALUE);
		int lastRowIndex = formTable.getRowCount();
		FieldLabel fieldLabel = new FieldLabel(label, markRequired);
		formTable.setWidget(lastRowIndex, 0, fieldLabel);
		formTable.getCellFormatter().setStyleName(lastRowIndex, 0, STYLE_LABEL_CELL);

		formTable.setWidget(lastRowIndex, 1, value);
		formTable.getCellFormatter().setStyleName(lastRowIndex, 1, STYLE_VALUE_CELL);

		return lastRowIndex;
	}

	public int addRow(LabelWidget label, Widget value) {
		return addRow(label, value, false);
	}

	public int addRow(String first, Widget second, boolean markRequired) {
		return addRow(new LabelWidget(first), second, markRequired);
	}

	public int addRow(String first, Widget second) {
		return addRow(first, second, false);
	}

	/**
	 * Get the number of fields in the form
	 * 
	 * @return The field count
	 */
	public int getFieldCount() {
		return this.formTable.getRowCount();
	}

	/**
	 * Get the index of the row that contains the field widget
	 * 
	 * @param widget A widget in a row cell in the table
	 */
	public int getFieldRowIndex(Widget widget) {
		for (int row = 0; row < formTable.getRowCount(); row++) {
			for (int column = 0; column < formTable.getCellCount(row); column++) {
				Widget cellWidget = formTable.getWidget(row, column);
				if (widget.equals(cellWidget)) {
					return row;
				}
			}
		}

		return -1;
	}

	/**
	 * Determine if a row containing a field is visible or not
	 * 
	 * @param index The index of the row the field is in
	 * @return true if visible, false if hidden
	 */
	public boolean isFieldRowVisible(int index) {
		return formTable.getRowFormatter().isVisible(index);
	}

	/**
	 * Set the row as visible or not
	 * 
	 * @param index The row index
	 * @param visible true to set visible, false to hide
	 */
	public void setFieldRowVisible(int index, boolean visible) {
		formTable.getRowFormatter().setVisible(index, visible);
	}

	/**
	 * Remove the field from the table given the index of the row
	 * 
	 * @param index The row index
	 */
	public void removeRow(int index) {
		formTable.removeRow(index);
	}

	/**
	 * Determine if the field in a given row is required
	 * 
	 * @param index The row index
	 * @return true if required, false otherwise
	 */
	public boolean isFieldRequired(int index) {
		FieldLabel widget = (FieldLabel) formTable.getWidget(index, 0);
		return widget.isRequired();
	}

	/**
	 * Set the field in a given row index as a required field in the form
	 * 
	 * @param index The row index
	 * @param required true to mark required, false otherwise
	 */
	public void setFieldRequired(int index, boolean required) {
		FieldLabel widget = (FieldLabel) formTable.getWidget(index, 0);
		widget.setRequired(required);
	}
	
	public void addButton(ButtonWidget buttonWidget) {
		buttonPanel.add(buttonWidget);
	}

	public void removeButton(ButtonWidget buttonWidget) {
		buttonPanel.remove(buttonWidget);
	}

	/*
	 * Internal class that manages a form 'label'
	 */
	private static final class FieldLabel extends Composite {

		private final HorizontalPanel panel;
		private final Label requiredLabel;
		private boolean required = false;
	
		public FieldLabel(Label label, boolean required) {
			this.panel = new HorizontalPanel();

			/* Build the required label */
			this.requiredLabel = new LabelWidget();
			this.requiredLabel.setStyleName(STYLE_REQUIRED);
			
			

			/* Add the field label */
			panel.add(label);
			
			panel.add(this.requiredLabel);
		
			/* Initialize the composite */
			this.initWidget(panel);

			/* Update the label */
			setRequired(required);
		}

		/**
		 * Check if the label is marked required
		 * 
		 * @return true if marked required, false otherwise
		 */
		public boolean isRequired() {
			return required;
		}

		/**
		 * Mark the label as required (or not required)
		 * 
		 * @param required true to mark as required, false otherwise
		 */
		public void setRequired(boolean required) {
			this.required = required;

			/* Set the text */
			String text = (this.required) ? "*" : "";
			this.requiredLabel.setText(text);

			/* Set the cell width */
			String width = (this.required) ? "10" : "";
			panel.setCellWidth(this.requiredLabel, width);
			
		}
	}
}
