/*
 * Created on Jan 7, 2010
 *
 * (C) Copyright TANDBERG Television Inc.
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

/**
 * The event handler interface for the event(s) resulting from changes made to the table view.
 * 
 * @author Vijay Silva
 */
public interface TableViewChangeHandler<K, R extends Record<K>> {

	/**
	 * The table view is changed to show the list view of the table
	 * 
	 * @param event The table view change event
	 */
	public void onShowListView(TableViewEvent event);

	/**
	 * The table view is changed to the detail view for a table record
	 * 
	 * @param event The event
	 */
	public void onShowDetailView(TableDetailViewEvent<K, R> event);
}
