/*
 * Created on May 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.RootPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link InlineHTML} widget.
 * 
 * @see com.google.gwt.user.client.ui.InlineHTML
 * @author Vijay Silva
 */
public class InlineHTMLWidget extends InlineHTML implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.InlineHTML#InlineHTML()
	 */
	public InlineHTMLWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.InlineHTML#InlineHTML(String)
	 */
	public InlineHTMLWidget(String html) {
		super(html);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.InlineHTML#InlineHTML(Element)
	 */
	protected InlineHTMLWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.InlineHTML#wrap(Element)
	 */
	public static InlineHTMLWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		InlineHTMLWidget widget = new InlineHTMLWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
