/*
 * Created on Feb 8, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.dnd;

import com.google.gwt.user.client.ui.FlexTable;

/**
 * Event triggered before the table row is moved using drag and drop. The event is triggered after
 * completing of the drop operation, but before the table row is actually moved.
 * 
 * @author Vijay Silva
 */
public class TableRowBeforeMoveEvent {

	/* Properties */
	private FlexTable source;
	private int rowIndex;
	private int targetRowIndex;
	private boolean canceled;

	/**
	 * Constructor
	 * 
	 * @param table The table on which the move operation was performed
	 * @param index The index of the row that needs to be moved
	 * @param targetIndex The index to which to move the row to
	 */
	public TableRowBeforeMoveEvent(FlexTable table, int index, int targetIndex) {
		this.source = table;
		this.rowIndex = index;
		this.targetRowIndex = targetIndex;
		this.canceled = false;
	}

	/**
	 * Get the table on which the move operation was performed
	 * 
	 * @return The table
	 */
	public FlexTable getSource() {
		return source;
	}

	/**
	 * Get the current index of the moved row
	 * 
	 * @return The row index
	 */
	public int getRowIndex() {
		return rowIndex;
	}

	/**
	 * Get the row index to which the row must be moved to
	 * 
	 * @return The new row index
	 */
	public int getTargetRowIndex() {
		return targetRowIndex;
	}

	/**
	 * Determine if the move operation has been canceled
	 * 
	 * @return true if canceled, false otherwise
	 */
	public boolean isCanceled() {
		return canceled;
	}

	/**
	 * Cancels the move operation
	 */
	public void cancel() {
		this.canceled = true;
	}
}
