/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.ericsson.neptune.alerts.entity.Alert;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.Member;
import com.tandbergtv.neptune.alerts.service.IAlertsAggregationService;
import com.tandbergtv.neptune.configuration.settings.entity.SettingGroup;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.settings.ejb.dao.SettingsDefinitionDAO;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.type.JavaType;

public class Aggregator
implements Runnable {
    private static final String PROPERTIES_FILE = "conf/neptune/alerts.properties";
    private static final String INSTALL_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final String BASE_ALERT_SETTING = "com.ericsson.cms.neptune.uialerts";
    private static final String ALERT_TIME_INTERVAL_SETTING = "com.ericsson.cms.neptune.uialerts.timeinterval";
    private static final String TIME_INTERVAL_SETTING = "time_interval";
    private static final String PROVIDER_URL_SETTING = "provider.url";
    private static final Logger logger = Logger.getLogger(Aggregator.class);
    private int responseTimeout = 10000;
    private String alertQueueName = "queue/AlertCmdQueue";
    IAlertsAggregationService alertsAggregationService = (IAlertsAggregationService)InjectionUtil.injectInstance((String)"cms/AlertsAggregationService/local", IAlertsAggregationService.class);
    ISettingsService configService = (ISettingsService)InjectionUtil.injectInstance((String)"cms/SettingsService/local", ISettingsService.class);

    public Aggregator(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    @Override
    public void run() {
        Member oldestNode = (Member)Hazelcast.getCluster().getMembers().iterator().next();
        if (Hazelcast.getCluster().getLocalMember().equals(oldestNode)) {
            this.pollAlertProviders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollAlertProviders() {
        InitialContext context = null;
        QueueSession queueSession = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        int daysDuration = Integer.parseInt((String)this.configService.getProperties(ALERT_TIME_INTERVAL_SETTING).get(TIME_INTERVAL_SETTING));
        Date dateBefore = new Date(System.currentTimeMillis() - (long)(daysDuration * 24 * 3600 * 1000));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Polling Date: " + dateFormat.format(dateBefore)));
        }
        try {
            context = new InitialContext();
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)context.lookup("java:/JmsXA");
            QueueConnection queueConnection = queueFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(true, 0);
            Queue queue = (Queue)context.lookup(this.alertQueueName);
            QueueSender queueSender = queueSession.createSender(queue);
            queueSender.setDeliveryMode(1);
            TemporaryQueue replyQueue = queueSession.createTemporaryQueue();
            int messageCount = 0;
            for (SettingGroup g : SettingsDefinitionDAO.getInstance().findSettingDefinitionsByParentPath(BASE_ALERT_SETTING)) {
                String providerURL = (String)this.configService.getProperties(g.getPath()).get(PROVIDER_URL_SETTING);
                if (providerURL == null || providerURL.isEmpty()) continue;
                StringBuilder startTime = new StringBuilder(dateFormat.format(dateBefore.getTime())).append(" 00:00:00");
                StringBuilder url = new StringBuilder();
                URI urlTemp = new URI(providerURL);
                if (urlTemp.isAbsolute()) {
                    url.append(urlTemp);
                } else {
                    url.append("https://localhost:8443").append(urlTemp);
                }
                url.append("?startTime=").append(URLEncoder.encode(startTime.toString(), "UTF-8"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Provider: " + g.getPath() + ", URL: " + url.toString()));
                }
                ObjectMessage message = queueSession.createObjectMessage();
                message.setJMSReplyTo((Destination)replyQueue);
                message.setStringProperty("url", url.toString());
                queueSender.send(queue, (Message)message);
                ++messageCount;
            }
            queueConnection.start();
            MessageConsumer consumer = queueSession.createConsumer((Destination)replyQueue);
            ArrayList<Alert> allAlerts = new ArrayList<Alert>();
            long lStartTime = System.nanoTime();
            for (int i = 0; i < messageCount; ++i) {
                String jSonString;
                long providerStart = System.currentTimeMillis();
                Message response = consumer.receive((long)this.responseTimeout);
                long providerEnd = System.currentTimeMillis();
                logger.debug((Object)("Received provider message after: " + (providerEnd - providerStart) + " millis"));
                TextMessage res = (TextMessage)response;
                if (res == null || (jSonString = res.getText()) == null || jSonString.isEmpty()) continue;
                List<Alert> componentAlertList = this.getAlertsFromJsonString(jSonString);
                allAlerts.addAll(componentAlertList);
            }
            long lEndTime = System.nanoTime();
            long difference = lEndTime - lStartTime;
            logger.debug((Object)("Elapsed milliseconds building provider responses: " + difference / 1000000L));
            logger.debug((Object)("Total # of alerts from polled alert providers: " + allAlerts.size()));
            this.alertsAggregationService.setAlerts(allAlerts);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending the event", (Throwable)e);
        }
        finally {
            try {
                if (queueSession != null) {
                    queueSession.close();
                }
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close the JMS session and context", (Throwable)e);
            }
        }
    }

    private List<Alert> getAlertsFromJsonString(String jsonString) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Class<?> clz = Class.forName(Alert.class.getName());
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clz);
        List alerts = (List)mapper.readValue(jsonString, (JavaType)type);
        return alerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readInitProperties() {
        Properties props = new Properties();
        InputStream is = null;
        String optFolder = System.getProperty(INSTALL_FOLDER_PROPERTY);
        if (optFolder == null) {
            optFolder = "/opt/tandbergtv/cms";
        }
        try {
            File f = new File(optFolder, PROPERTIES_FILE);
            is = new FileInputStream(f);
            props.load(is);
        }
        catch (IOException e) {
            logger.debug((Object)"Can not load properties from conf/neptune/alerts.properties", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Can not close input stream for properties file conf/neptune/alerts.properties", (Throwable)e);
                }
            }
        }
        return props;
    }
}

