/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.portaluserprefmgmt.ejb;

import com.ericsson.neptune.portaluserprefmgmt.service.IPortalUserPreferenceManager;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.realm.persist.PortalUserPreference;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Local(value={IPortalUserPreferenceManager.class})
@Stateless
public class PortalUserPreferenceManager
implements IPortalUserPreferenceManager {
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;
    private IAuthorizationService authorizationService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);

    public PortalUserPreference create(PortalUserPreference portalUserPreference) {
        portalUserPreference.setUserName(this.authorizationService.getUserName());
        this.entityManager.persist((Object)portalUserPreference);
        this.entityManager.flush();
        return portalUserPreference;
    }

    public List<PortalUserPreference> create(List<PortalUserPreference> portalUserPreferences) {
        if (portalUserPreferences != null) {
            for (PortalUserPreference portalUserPreference : portalUserPreferences) {
                portalUserPreference.setUserName(this.authorizationService.getUserName());
                this.entityManager.persist((Object)portalUserPreference);
            }
            this.entityManager.flush();
        }
        return portalUserPreferences;
    }

    public void deletePreferences(String component) {
        Query query = this.entityManager.createNamedQuery("PortalUserPref.DeleteByComponent");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        query.setParameter("component", (Object)component);
        query.executeUpdate();
        this.entityManager.flush();
    }

    public List<PortalUserPreference> getPreferences() {
        Query query = this.entityManager.createNamedQuery("PortalUserPref.FindByUser");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        return query.getResultList();
    }

    public PortalUserPreference save(PortalUserPreference portalUserPreference) {
        this.entityManager.merge((Object)portalUserPreference);
        this.entityManager.flush();
        return portalUserPreference;
    }

    public void deletePreference(String component, String key) {
        Query query = this.entityManager.createNamedQuery("PortalUserPref.DeleteByComponentAndKey");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        query.setParameter("component", (Object)component);
        query.setParameter("key", (Object)key);
        query.executeUpdate();
        this.entityManager.flush();
    }

    public PortalUserPreference getPreference(String component, String key) {
        Query query = this.entityManager.createNamedQuery("PortalUserPref.FindByComponentAndKey");
        query.setParameter("userName", (Object)this.authorizationService.getUserName());
        query.setParameter("component", (Object)component);
        query.setParameter("key", (Object)key);
        PortalUserPreference portalUserPreference = null;
        try {
            portalUserPreference = (PortalUserPreference)query.getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return portalUserPreference;
    }
}

