/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.component.service;

import com.ericsson.neptune.component.entity.BasicMenuItem;
import com.ericsson.neptune.component.entity.BasicPortlet;
import com.ericsson.neptune.component.entity.IMenuItem;
import com.ericsson.neptune.component.entity.IPortlet;
import com.tandbergtv.neptune.authorization.service.IExternalModuleProvider;
import com.tandbergtv.neptune.util.StringFormatUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class BasicComponentModuleProvider
implements IExternalModuleProvider {
    private static final long serialVersionUID = 1L;
    private String name;
    private String displayName;
    BasicMenuItem rootMenu;
    List<IPortlet> portlets;
    Map<String, String> namedLocations;

    public BasicComponentModuleProvider() {
        this(null, null);
    }

    public BasicComponentModuleProvider(String name) {
        this(name, name);
    }

    public BasicComponentModuleProvider(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.rootMenu = new BasicMenuItem();
        this.setPortlets(null);
        this.namedLocations = new HashMap<String, String>();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setMenuItems(List<IMenuItem> menuItems) {
        this.rootMenu.setChildren(menuItems);
    }

    @Override
    public List<IMenuItem> getMenuItems() {
        return this.rootMenu.getChildren();
    }

    public void setPortlets(List<IPortlet> portlets) {
        if (portlets == null) {
            portlets = new ArrayList<IPortlet>();
        }
        this.portlets = portlets;
    }

    @Override
    public List<IPortlet> getPortlets() {
        return this.portlets;
    }

    public void addNeptunePortlet(String portletId, String displayName) {
        this.addNeptunePortlet(portletId, displayName, null);
    }

    public void addNeptunePortlet(String portletId, String displayName, String[] roles) {
        this.addDefaultLocationPortlet(portletId, displayName, this.getPortletUrl(portletId), roles);
    }

    public void addDefaultLocationPortlet(String portletId, String displayName, String url, String[] roles) {
        BasicPortlet portlet = new BasicPortlet(portletId, displayName, url, roles);
        this.portlets.add(portlet);
    }

    public void addNamedLocationPortlet(String portletId, String displayName, String namedLoc, String url, String[] roles) {
        BasicPortlet portlet = new BasicPortlet(portletId, displayName, url, roles);
        portlet.setURLLocationName(namedLoc);
        this.portlets.add(portlet);
    }

    private String getPortletUrl(String portletId) {
        return "#Portlet." + StringFormatUtil.getFormattedName(this.name) + "." + StringFormatUtil.getFormattedName(portletId);
    }

    public void addNeptuneMenuItem(String[] menuHierarchyNames, String name) {
        this.addNeptuneMenuItem(menuHierarchyNames, menuHierarchyNames, name, name, false, null);
    }

    public void addNeptuneMenuItem(String[] menuHierarchyNames, String[] menuHierarchyDisplayNames, String name, String displayName) {
        this.addNeptuneMenuItem(menuHierarchyNames, menuHierarchyDisplayNames, name, displayName, false, null);
    }

    public void addNeptuneMenuItem(String[] menuHierarchy, String name, String[] roles) {
        this.addNeptuneMenuItem(menuHierarchy, menuHierarchy, name, name, false, roles);
    }

    public void addNeptuneMenuItem(String[] menuHierarchy, String[] menuHierarchyDisplayNames, String name, String displayName, String[] roles) {
        this.addNeptuneMenuItem(menuHierarchy, menuHierarchyDisplayNames, name, displayName, false, roles);
    }

    public void addNeptuneMergeMenuItem(String[] menuHierarchyNames, String name) {
        this.addNeptuneMenuItem(menuHierarchyNames, menuHierarchyNames, name, name, true, null);
    }

    public void addNeptuneMergeMenuItem(String[] menuHierarchyNames, String[] menuHierarchyDisplayNames, String name, String displayName) {
        this.addNeptuneMenuItem(menuHierarchyNames, menuHierarchyDisplayNames, name, displayName, true, null);
    }

    public void addNeptuneMergeMenuItem(String[] menuHierarchy, String name, String[] roles) {
        this.addNeptuneMenuItem(menuHierarchy, menuHierarchy, name, name, true, roles);
    }

    public void addNeptuneMergeMenuItem(String[] menuHierarchyNames, String[] menuHierarchyDisplayNames, String name, String displayName, String[] roles) {
        this.addNeptuneMenuItem(menuHierarchyNames, menuHierarchyDisplayNames, name, displayName, true, roles);
    }

    private void addNeptuneMenuItem(String[] menuHierarchyNames, String[] menuHierarchyDisplayNames, String name, String displayName, boolean isProxy, String[] roles) {
        String url = "#";
        for (String groupName : menuHierarchyNames) {
            url = url + groupName + ".";
        }
        url = url + name;
        this.addMenuItem(menuHierarchyNames, menuHierarchyDisplayNames, name, displayName, isProxy, roles, url, null);
    }

    public void addNamedLocationMenuItem(String[] menuHierarchy, String namedLoc, String url, String name) {
        this.addMenuItem(menuHierarchy, menuHierarchy, name, name, false, null, url, namedLoc);
    }

    public void addNamedLocationMenuItem(String[] menuHierarchy, String namedLoc, String url, String name, String[] roles) {
        this.addMenuItem(menuHierarchy, menuHierarchy, name, name, false, roles, url, namedLoc);
    }

    public void addNamedLocationMergeMenuItem(String[] menuHierarchy, String namedLoc, String url, String name) {
        this.addMenuItem(menuHierarchy, menuHierarchy, name, name, true, null, url, namedLoc);
    }

    public void addNamedLocationMergeMenuItem(String[] menuHierarchy, String namedLoc, String url, String name, String[] roles) {
        this.addMenuItem(menuHierarchy, menuHierarchy, name, name, true, roles, url, namedLoc);
    }

    private void addMenuItem(String[] menuHierarchyNames, String[] menuHierarchyDisplayNames, String name, String displayName, boolean isProxy, String[] roles, String url, String namedLoc) {
        IMenuItem parent = this.rootMenu;
        int depth = Math.min(menuHierarchyNames.length, menuHierarchyDisplayNames.length);
        for (int index = 0; index < depth; ++index) {
            parent = this.addGroup(menuHierarchyNames[index], menuHierarchyDisplayNames[index], parent, isProxy);
        }
        BasicMenuItem leaf = new BasicMenuItem();
        leaf.setName(name);
        leaf.setDisplayName(displayName);
        leaf.setURL(url);
        leaf.setURLLocationName(namedLoc);
        leaf.setMergeRequired(isProxy);
        if (roles == null) {
            leaf.setRoles(null);
        } else {
            leaf.setRoles(new HashSet<String>(Arrays.asList(roles)));
        }
        parent.getChildren().add(leaf);
    }

    private IMenuItem addGroup(String groupName, String groupDisplayName, IMenuItem parent, boolean isProxy) {
        for (IMenuItem next : parent.getChildren()) {
            if (next.isLeaf() || !next.getName().equals(groupName)) continue;
            if (!next.getDisplayName().equals(groupDisplayName) && groupDisplayName != null && groupDisplayName.length() > next.getDisplayName().length()) {
                next.setDisplayName(groupDisplayName);
            }
            return next;
        }
        BasicMenuItem group = new BasicMenuItem();
        group.setName(groupName);
        group.setDisplayName(groupDisplayName);
        group.setMergeRequired(isProxy);
        parent.getChildren().add(group);
        return group;
    }

    @Override
    public Map<String, String> getNamedLocations() {
        return this.namedLocations;
    }

    public void addNamedLocation(String name, String value) {
        this.namedLocations.put(name, value);
    }
}

