package com.tandbergtv.neptune.ui.realm.client.networkelements.service;

import java.io.Serializable;

/**
 * 		Enum for the possible NetworkElements statuses.
 * 
 * @author Francisco B. S. Neto
 *
 */
public enum UiNetworkElementStatus implements Serializable {
	
	ACTIVE (1),
	INACTIVE (2),
	FAILED (3),
	// Means that the NetElement is not configured on the particular network configuration.
	DISABLED (0);

	private final int status;
	UiNetworkElementStatus(int status) {
		this.status = status;
	}
	
	public int getStatusValue() {
		return status;
	}
	/**
	 * 		Returns the enum corresponding to the status code, or null if none matches.
	 * 
	 * @param status
	 * @return
	 */
	public static UiNetworkElementStatus valueOf(int status) {
		for (UiNetworkElementStatus a : values()) {
			if (a.status == status) {
				return a;
			}
		}
		return null;
	}
	
	public boolean isActive() {
		return this == ACTIVE;
	}
	
	public boolean isInactive() {
		return this == INACTIVE;
	}
	
	public boolean isFailed() {
		return this == FAILED;
	}
	
	public boolean isDisabled() {
		return this == DISABLED;
	}
	
}
