/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.application.event;

import com.google.gwt.event.shared.GwtEvent;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;

/**
 * Event to handle the application 'show about' event
 * 
 * @author Vijay Silva
 */
public class ShowAboutEvent extends GwtEvent<ShowAboutHandler> {

	/* The Handler type */
	private static Type<ShowAboutHandler> TYPE;

	/* The application */
	private NeptuneApplication application;

	/**
	 * Constructor
	 * 
	 * @param application The application firing the event
	 */
	public ShowAboutEvent(NeptuneApplication application) {
		this.application = application;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<ShowAboutHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<ShowAboutHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<ShowAboutHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(ShowAboutHandler handler) {
		handler.onShowAbout(this);
	}

	/**
	 * @return the application
	 */
	public NeptuneApplication getApplication() {
		return application;
	}
}
