/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.licensing;

import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.licensing.LicenseType;
import com.tandbergtv.neptune.licensing.elim.ELIMLicense;
import java.io.ByteArrayInputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class CertificateUtil {
    private static final String DEV_ROOT_CERT_STR = "-----BEGIN CERTIFICATE-----\nMIICRzCCAbCgAwIBAgIIbuviEeCeY14wDQYJKoZIhvcNAQEFBQAwZjELMAkGA1UEBhMCU0UxFDASBgNVBAoTC0VyaWNzc29uIEFCMQ0wCwYDVQQLEwRCVVNTMTIwMAYDVQQDEylFcmljc3NvbiBEZXZlbG9wbWVudCBMaWNlbnNlIFRvb2wgUm9vdCBDQTAeFw0xNDA0MTcyMTI2NTZaFw0yNDA0MTQyMTI2NTZaMGYxCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtFcmljc3NvbiBBQjENMAsGA1UECxMEQlVTUzEyMDAGA1UEAxMpRXJpY3Nzb24gRGV2ZWxvcG1lbnQgTGljZW5zZSBUb29sIFJvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAKJoa2WgWmfSYRbHDko4kEA/hGmdnv1upuYF14b6cUKy1PdWWlHmiVUE1jI9LTt39deYSr6oQ9YeQO5qF8vx0Jihu4BEN+H3pMc7yvp9iW2a8tjn+FjtFRYKH7yZAnno72Ex/DDMGrgGrgulDyITipa6LLY2irmuMPewfig0WIujAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEAmKYlwiVovr/TGDpkoM01PsbupO8Qgo3ojQyPq16DaZDY1i1w3ZGuCKZWZvXcmSU2oIP3EmbW9pQYN5IdsmX2CWfBHEVFUpdUET8k3jZfigWvdhn22eyDf4Pv5RcLkVHBziH2HjtaRLwPK8Gwc7N5QXh2chkDHNTG0c/15UQj4Ho=\n-----END CERTIFICATE-----";
    private static final String PROD_ROOT_CERT_STR = "-----BEGIN CERTIFICATE-----\nMIIDqzCCApOgAwIBAgIBATANBgkqhkiG9w0BAQUFADB1MQswCQYDVQQGEwJTRTEUMBIGA1UEChMLRXJpY3Nzb24gQUIxFzAVBgNVBAsTDkxpY2Vuc2UgQ2VudGVyMTcwNQYDVQQDEy5Sb290IGZvciBzaWduaW5nIGxpY2Vuc2UgZmlsZXMgQ0FYIDEwNiAwMDg0LzU3MCIYDzIwMTQwNTI3MDAwMDAwWhgPMjAzODAxMTgwMDAwMDBaMHUxCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtFcmljc3NvbiBBQjEXMBUGA1UECxMOTGljZW5zZSBDZW50ZXIxNzA1BgNVBAMTLlJvb3QgZm9yIHNpZ25pbmcgbGljZW5zZSBmaWxlcyBDQVggMTA2IDAwODQvNTcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDACdyiBUGt3bMwe0wjTjVoq4UnITlXF3fIbX5yaEQ/3/wjcoRAqmWOJKyi/jX8h0iNnndKjZiA0H3lf8Wqw9x+JlyUaA7jmsoZ2+JP3QeGluCnrZIjxeHnS76Ne4by5EP39wWmQon031oWTroCXbR36xFboKWj1S8EfD1ScilUCYi5SJTVjbHkD15dTtpDTXkSIqylglj+PEda/YYFz2HZVYuRZon3kT4HbQtwu5B5J2AUP9NKiVMTWM3Y7wimOzC4LtU6lLMcABgMbRMQ5aHmVNkSeBaTXlmCbNtTwYLsjM0/uPqWiegQbhKhsbsqZGbgh2+yVlQmQ6oMFbzy9WBjAgMBAAGjQjBAMB0GA1UdDgQWBBSkHwuHmaNP+RuwmLYGFqiPleyKDDASBgNVHRMBAf8ECDAGAQH/AgEBMAsGA1UdDwQEAwIBBjANBgkqhkiG9w0BAQUFAAOCAQEAo9pHX2IPT+Ei7ZTWEPa0WCZ3+nOGZN51kGRJ06rqLQE08BQQ0zoc3oPNkMN+WitFhGu6d8oT1+x8q/C5f2NiBplIcLywwFKZkXgcOnzBOrpcGG5tc/7+noCVdR/bUw143fiQ+3gr/f9lbj29RJ8lyzZwUKe+VAevBIgNVSyy0C2i0i+jZnfYexG93CPbfFaZ6edfSQmDil2YKAQwyNauwWYP/5Wr156aaU0XCaAvae8fcVjc+QRJRdG4IGUeEuaE3wqGEAOBdK2QIRmrF9JPJSAzx1B7a7S2I4r7hDenyMo22fZ+eM6jvrHi4RLUeqR5WQ/Ddiau0zr71AjyJ/f2LQ==\n-----END CERTIFICATE-----";
    public static final String X509_CERT_TYPE = "X.509";
    private static final Logger logger = Logger.getLogger(CertificateUtil.class);

    public boolean validateCertificateChain(LicenseType licType, ELIMLicense elimLicXml) throws InvalidLicenseException {
        boolean validCerts = false;
        logger.debug((Object)("Validating cert chain for license type " + (Object)((Object)licType)));
        X509Certificate rootCert = null;
        X509Certificate caCert = null;
        X509Certificate prodCert = null;
        try {
            rootCert = this.buildRootCertificate(licType);
            caCert = this.buildCertificate(elimLicXml.getCACert());
            prodCert = this.buildCertificate(elimLicXml.getProdCert());
            rootCert.verify(rootCert.getPublicKey());
            caCert.verify(rootCert.getPublicKey());
            prodCert.verify(caCert.getPublicKey());
            validCerts = true;
        }
        catch (CertificateException e) {
            logger.error((Object)("Caught CertificateException : " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)("Caught InvalidKeyException : " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("Caught NoSuchAlgorithmException : " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            logger.error((Object)("Caught NoSuchProviderException : " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
        }
        catch (SignatureException e) {
            logger.error((Object)("Caught SignatureException : " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
        }
        return validCerts;
    }

    public X509Certificate buildCertificate(String certStr) throws CertificateException {
        X509Certificate cert = null;
        cert = (X509Certificate)CertificateFactory.getInstance(X509_CERT_TYPE).generateCertificate(new ByteArrayInputStream(certStr.getBytes()));
        return cert;
    }

    public X509Certificate buildRootCertificate(LicenseType licType) throws CertificateException {
        String rootCertStr = DEV_ROOT_CERT_STR;
        rootCertStr = licType == LicenseType.LAB || licType == LicenseType.DEV ? DEV_ROOT_CERT_STR : PROD_ROOT_CERT_STR;
        return this.buildCertificate(rootCertStr);
    }
}

