/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.activity;

import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.usermgmt.activity.IUserActivity;
import com.tandbergtv.neptune.usermgmt.activity.IUserActivityLogService;
import com.tandbergtv.neptune.usermgmt.activity.UserActivity;
import com.tandbergtv.neptune.usermgmt.activity.UserActivityFactory;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.Date;

public class DefaultUserActivityFactory
extends UserActivityFactory {
    private static final String AUTHORIZATION_SERVICE = "cms/AuthorizationService/local";
    private static final String LOG_SERVICE = "cms/UserActivityLogService/local";

    public IUserActivity createUserActivity(String activityName, boolean activitySuccessful) {
        UserActivity activity = new UserActivity();
        activity.setTimestamp(new Date());
        activity.setActivityName(activityName);
        activity.setActivitySuccessful(activitySuccessful);
        IAuthorizationService service = (IAuthorizationService)InjectionUtil.injectInstance((String)AUTHORIZATION_SERVICE, IAuthorizationService.class);
        activity.setUserName(service.getUserName());
        return activity;
    }

    public IUserActivity createUserActivity(String activityName, String description, boolean activitySuccessful) {
        IUserActivity activity = this.createUserActivity(activityName, activitySuccessful);
        activity.setDescription(description);
        return activity;
    }

    public IUserActivityLogService getUserActivityLogService() {
        return (IUserActivityLogService)InjectionUtil.injectInstance((String)LOG_SERVICE, IUserActivityLogService.class);
    }
}

