/**
 * This file was modified from GoogleGadgetPortlet.
 */
/*
 * GWT Portlets Framework (http://code.google.com/p/gwtportlets/)
 * Copyright 2009 Business Systems Group (Africa)
 *
 * GWT Portlets is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GWT Portlets is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GWT Portlets.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.tandbergtv.neptune.ui.portalpage.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HTML;

import org.gwtportlets.portlet.client.WidgetFactory;
import org.gwtportlets.portlet.client.layout.LDOM;
import org.gwtportlets.portlet.client.ui.Portlet;
import org.gwtportlets.portlet.client.ui.PortletFactory;

/**
 * Displays a portlet in an iframe.
 */
public class PortletFrame extends Portlet {

	private String component;
    private String url;
    private int lastWidth = -1;
    private int lastHeight = 0;

    private HTML html = new HTML();
        
    private static final String SCRIPT_SRC = "<script src=\"";
    private static final String SCRIPT_SRC_END = "\"></script>";

    public PortletFrame() {
        initWidget(html);
        setStyleName("");
    }

    public String getComponent() {
    	return component;
    }
    
    public void setComponent(String component) {
    	this.component = component;
    }
    
    public String getUrl() {
    	return url;
    }
    
    public void setUrl(String url) {
    	url = formatUrl(url);
        this.url = url;
        lastWidth = -1;
        update();
    }
    
    public String formatUrl(String url) {
        if (url == null) {
            url = "";
        }
        // remove <script> wrapper
        if (url.startsWith(SCRIPT_SRC)) {
            url = url.substring(SCRIPT_SRC.length());
        }
        if (url.endsWith(SCRIPT_SRC_END)) {
            url = url.substring(0, url.length() - SCRIPT_SRC_END.length());
        }
        // change output type to html
        url = url.replaceAll("&amp;output=js", "&amp;output=html");
        // remove width and height
        url = url.replaceAll("&amp;w=\\d+&amp;", "&amp;");
        url = url.replaceAll("&amp;h=\\d+&amp;", "&amp;");
        // replace space with %20
        url = url.replaceAll(" ", "%20");
        return url.trim();
    }

    public void boundsUpdated() {
    	if (!isAttached()) {
    		return;
    	}
    	Element e = getElement();
    	if (LDOM.getContentWidth(e) != lastWidth) {
        	update();
        } else if (LDOM.getContentHeight(e) != lastHeight) {
        	setIframeHeight();
        }
    }
    
    public void setHeight(int height) {
    	lastHeight = height;
    }
    
    public int getLastHeight() {
    	return lastHeight;
    }
    
    private void update() {
        if (!isAttached()) {
            return;
        }
        Element e = getElement();
        lastWidth = LDOM.getContentWidth(e);
        lastHeight = LDOM.getContentHeight(e);
        if (url == null || url.length() == 0) {
            html.setHTML("No gadget");
        } else {
            StringBuffer s = new StringBuffer();
            s.append("<iframe src=\"\" height = \"")
                    .append(lastHeight).append("\" width = \"").append(lastWidth)
                    .append("\" frameborder = \"0\" scrolling = \"no\"></iframe>");
            html.setHTML(s.toString());
            Element iframe = DOM.getFirstChild(html.getElement());
            DOM.setElementAttribute(iframe, "src", url);
        }
    }
    
    private void setIframeHeight() {
        if (!isAttached() || url == null || url.length() == 0) {
            return;
        }
        Element e = getElement();
        lastHeight = LDOM.getContentHeight(e);
        Element iframe = DOM.getFirstChild(html.getElement());
        DOM.setElementAttribute(iframe, "height", Integer.toString(lastHeight));
    }
    
    public boolean isConfigureSupported() {
        return false;
    }

    public WidgetFactory<PortletFrame> createWidgetFactory() {
        return new Factory(this);
    }

    public static class Factory extends PortletFactory<PortletFrame> {
    	
		private static final long serialVersionUID = 1L;
		
		public String component;
		public String url;

        public Factory() {
        }

        public Factory(PortletFrame p) {
            super(p);
            component = p.component;
            url = p.url;
        }

        public void refresh(PortletFrame p) {
            super.refresh(p);
            p.setComponent(component);
            p.setUrl(url);
        }

        public PortletFrame createWidget() {
            return new PortletFrame();
        }
    }

}

