package com.tandbergtv.neptune.ui.componentmgr.client.tab.component.view;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.ui.componentmgr.client.tab.component.model.UiComponent;
import com.tandbergtv.neptune.ui.componentmgr.client.tab.component.model.UiComponentKey;
import com.tandbergtv.neptune.ui.componentmgr.client.tab.component.model.UiComponentList;
import com.tandbergtv.neptune.ui.componentmgr.client.tab.component.service.ComponentUiService;
import com.tandbergtv.neptune.ui.componentmgr.client.tab.component.service.ComponentUiServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

/**
 * The data provider for the component entity
 * 
 */
final class ComponentDataProvider implements DataProvider<UiComponentKey, ComponentRecord> {

	private final ComponentTableView view;
	private ComponentUiServiceAsync service;
	private List<Column<?, ComponentRecord>> columns = null;

	/* The column names */
	public static final String NAME_COLUMN = "name";
	public static final String STATUS_COLUMN = "statusId";
	public static final String LAST_SYNC_COLUMN = "lastSuccessfulSynchTimestamp";

	/**
	 * Constructor
	 */
	public ComponentDataProvider(ComponentTableView view) {
		this.view = view;
	}

	/*
	 * No initialization required
	 */
	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	/*
	 * Get the columns
	 */
	@Override
	public List<Column<?, ComponentRecord>> getColumns() {
		if (this.columns == null) {
			/* Build the columns if not previously built */
			this.columns = new ArrayList<Column<?, ComponentRecord>>();

			/* The name column */
			String nameDisplayName = null;
			nameDisplayName = view.getComponentConstants().componentNameColumn();
			ComponentTableColumn nameColumn = new ComponentTableColumn(this, NAME_COLUMN, nameDisplayName);
			nameColumn.setHandlingViewClick(true);
			nameColumn.setColumnWidth("34%");
			this.columns.add(nameColumn);
			
			/* The status column */
			String statusDisplayName = null;
			statusDisplayName = view.getComponentConstants().componentStatusColumn();
			ColumnBase<String, ComponentRecord> statusColumn = new ColumnBase<String, ComponentRecord>(STATUS_COLUMN, statusDisplayName) {
				public View<String> getView(ComponentRecord record) {
					return new LabelStringView(record.getComponent().getStatus());
				}
			};
			this.columns.add(statusColumn);			
		}
		
		/* The Last Successful Synch column */
		String lastSuccessfulSynchDisplayName = null;
		lastSuccessfulSynchDisplayName = view.getComponentConstants().componentLastSuccessfulSynchTimestampColumn();		
		ColumnBase<String, ComponentRecord> lastSuccessfulSynchColumn = new ColumnBase<String, ComponentRecord>(LAST_SYNC_COLUMN, lastSuccessfulSynchDisplayName) {
			public View<String> getView(ComponentRecord record) {
				String lastSynchTimestamp = "";
				try {
					DateTimeFormat format = DateTimeFormat.getFormat("MM/dd/yyyy HH:mm:ss");
					lastSynchTimestamp = format.format(record.getComponent().getLastSuccessfulSynchTimestamp());
				} catch (RuntimeException e) {
				}
				return new LabelStringView(lastSynchTimestamp);
			}
		};
		this.columns.add(lastSuccessfulSynchColumn);	

		return this.columns;
	}

	/**
	 * Get a column given the column name
	 * 
	 * @param columnName The column name
	 * @return The matching column, or null if no column matches
	 */
	public Column<?, ComponentRecord> getColumn(String columnName) {
		for (Column<?, ComponentRecord> column : getColumns()) {
			if (columnName.equals(column.getName()))
				return column;
		}

		return null;
	}

	@Override
	public void getRecords(final AsyncCallback<List<ComponentRecord>> callback) {
		PageFeature pageFeature = view.getTable().getPageFeature();
		int pageSize = pageFeature.getPageSize();
		int startIndex = (pageFeature.getPageNumber() - 1) * pageSize;

		SortFeature<UiComponentKey, ComponentRecord> sortFeature = view.getTable().getSortFeature();
		Column<?, ComponentRecord> sortColumn = sortFeature.getSortColumn();
		String sortByProperty = (sortColumn != null) ? sortColumn.getName() : null;
		boolean isAscending = SortOrder.ASCENDING.equals(sortFeature.getSortOrder());

		/* Get the components */
		view.getBusyIndicator().center();
		getService().listComponents(startIndex, pageSize, sortByProperty, isAscending, new NeptuneAsyncCallback<UiComponentList>() {

	        @Override
	        public void onNeptuneFailure(Throwable caught) {
		        view.getBusyIndicator().hide();
		        view.getTable().getPageFeature().setRecordCount(-1);
		        callback.onFailure(caught);
	        }

	        @Override
	        public void onNeptuneSuccess(UiComponentList result) {
		        view.getBusyIndicator().hide();
		        List<ComponentRecord> records = new ArrayList<ComponentRecord>();
		        for (UiComponent component : result.getComponents())
			        records.add(new ComponentRecord(component));
		        view.getTable().getPageFeature().setRecordCount(result.getTotal());
		        callback.onSuccess(records);
	        }
        });
	}

	@Override
	public void getRecord(UiComponentKey key, final AsyncCallback<ComponentRecord> callback) {
		view.getBusyIndicator().center();
		getService().getComponent(key.getId(), new NeptuneAsyncCallback<UiComponent>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				view.getBusyIndicator().hide();
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(UiComponent result) {
				view.getBusyIndicator().hide();
				callback.onSuccess(new ComponentRecord(result));
			}
		});
	}

	@Override
	public boolean isRecordCountEnabled() {
		/* Show the record count */
		return true;
	}

	@Override
	public boolean isCheckboxEnabled() {
		/* Delete is the only batch operation */
		return view.canDeleteRecords();
	}

	/*
	 * Handle notification from the column that a record was clicked
	 */
	void handleRecordClick(ComponentRecord record) {
		/* Notify the view that the record was clicked */
		view.handleTableRecordClick(record);
	}

	/*
	 * Get the component management service
	 */
	private ComponentUiServiceAsync getService() {
		if (service == null)
			service = GWT.create(ComponentUiService.class);

		return service;
	}
	
}
