package com.tandbergtv.neptune.ui.portalpage.client.ui;

import org.gwtportlets.portlet.client.WidgetFactory;
import org.gwtportlets.portlet.client.WidgetInfo;
import org.gwtportlets.portlet.client.layout.ContainerFactory;
import org.gwtportlets.portlet.client.layout.LayoutHandler;
import org.gwtportlets.portlet.client.ui.LayoutPanel;

import com.google.gwt.user.client.ui.Widget;

public class ColumnPanel extends LayoutPanel {

	public ColumnPanel() {
		super(true);
	}
	
	@Override
	public void add(Widget widget) {
		super.add(widget);
		if (widget instanceof LayoutHandler) {
			addLayoutHandler((LayoutHandler) widget);
		}
	}

	@Override
    public WidgetFactory<ColumnPanel> createWidgetFactory() {
        return new Factory(this);
    }

    @WidgetInfo(description = "Column Panel in a Column Sizing Layout Panel")
    public static class Factory extends ContainerFactory<ColumnPanel> {

		private static final long serialVersionUID = 1L;

		private boolean limitMaximize;

        public Factory() {
        }

        public Factory(ColumnPanel c) {
            super(c);
            limitMaximize = c.isLimitMaximize();
        }

        public void refresh(ColumnPanel p) {
            refreshSettings(p);
            super.refresh(p);
        }

        /**
         * Refresh only the configurable settings of p.
         */
        public void refreshSettings(ColumnPanel p) {
            p.setLimitMaximize(limitMaximize);
        }

        public ColumnPanel createWidget() {
            return new ColumnPanel();
        }
    }
    
}
