/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.util;

import com.ericsson.neptune.security.NeptunePrincipal;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

public class EndpointAuthorizationUtil {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";

    public static Response.ResponseBuilder authorizePermissions(HttpServletRequest httpRequest, Response.ResponseBuilder builder, String requestMethod, String ... permissions) {
        NeptunePrincipal nsp = (NeptunePrincipal)httpRequest.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        if (nsp != null && nsp.getRoles() != null) {
            HashSet<String> roles = new HashSet<String>(nsp.getRoles());
            if (httpRequest.getMethod().equals(requestMethod)) {
                for (String permission : permissions) {
                    if (roles.contains(permission)) continue;
                    builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
                    return builder;
                }
            }
        } else {
            builder = Response.status((Response.Status)Response.Status.FORBIDDEN);
            return builder;
        }
        return builder;
    }

    public static Response.ResponseBuilder authorizePermissionsGET(HttpServletRequest httpRequest, Response.ResponseBuilder builder, String ... permissions) {
        return EndpointAuthorizationUtil.authorizePermissions(httpRequest, builder, "GET", permissions);
    }
}

