/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import com.ericsson.neptune.security.authprovider.TokenInfo;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebServicesAuthenticationFilter
extends BaseSecurityFilter {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_VALIDATE_URL = "neptune_sso_oauth2_provider_validate_url";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_WEBSERVICES_URL = "neptune_sso_webservice_url";
    private static final String DEFAULT_PROVIDER_VALIDATE_URL = "https://localhost:8443/provider/oauth/validate";
    protected String providerValidateUrl;
    protected AuthProviderClient providerClient;
    private String providerWebserviceUrl;
    private boolean isNeptune;

    private NeptunePrincipal doBasic(String header, NeptunePrincipal nsp, HttpServletResponse response) throws IOException {
        try {
            String base64Val = header.substring(6);
            String decodedVal = new String(Base64.decode(base64Val));
            int ColonIndex = decodedVal.indexOf(":");
            String username = decodedVal.substring(0, ColonIndex);
            String password = decodedVal.substring(ColonIndex + 1);
            nsp = new NeptunePrincipal(username);
            nsp.setToken(password);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Error while doing Basic Authorization", (Throwable)ex);
            this.doError401(response);
        }
        return nsp;
    }

    private NeptunePrincipal doBearer(String header, HttpServletRequest request, NeptunePrincipal principal, HttpServletResponse response) throws IOException {
        String accessToken = header.substring(7);
        TokenInfo tokenInfo = this.providerClient.validateToken(accessToken, request);
        if (tokenInfo == null) {
            this.logger.error((Object)"Internal server error, could not proceed. Please check previous exception.");
            this.doError500(response);
            return null;
        }
        if (!tokenInfo.isValid()) {
            this.logger.error((Object)("Invalid token found: " + tokenInfo));
            this.doError401(response);
            return null;
        }
        this.logger.debug((Object)"Login succeeded at provider, caching user info");
        principal = new NeptunePrincipal(tokenInfo, accessToken);
        return principal;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        NeptunePrincipal nsp = null;
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || authHeader.isEmpty()) {
            this.doError401(response);
            this.logger.error((Object)"Authorization header was absent.Could not proceed.");
            return;
        }
        if (authHeader.startsWith("Basic")) {
            nsp = this.doBasic(authHeader, nsp, response);
        } else {
            if (!authHeader.startsWith("Bearer")) {
                this.doError401(response);
                this.logger.error((Object)"Authorization header was invalid.Could not proceed.");
                return;
            }
            if (!this.isNeptune) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            nsp = this.doBearer(authHeader, request, nsp, response);
        }
        if (nsp != null) {
            this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
            request.setAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL, (Object)nsp);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
    }

    private void doError401(HttpServletResponse response) throws IOException {
        response.sendError(401, "Invalid user credentials");
    }

    private void doError500(HttpServletResponse response) throws IOException {
        response.sendError(500, "Internal server error");
    }

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        this.providerClient = new AuthProviderClient();
        this.providerValidateUrl = this.providerUrls.getProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_VALIDATE_URL);
        this.providerWebserviceUrl = this.providerUrls.getProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_WEBSERVICES_URL);
        if (this.isEmpty(this.providerValidateUrl)) {
            this.logger.debug((Object)"neptune_sso_oauth2_provider_validate_url is not set. Set it to the default value: https://watchpoint-app:8443/provider/oauth/validate");
            this.providerValidateUrl = DEFAULT_PROVIDER_VALIDATE_URL;
        }
        this.providerClient.setValidateUrl(this.providerValidateUrl);
        if (this.providerWebserviceUrl == null) {
            this.logger.debug((Object)"neptune_sso_webservice_url is not set. Setting it to empty");
            this.isNeptune = true;
        } else if (this.providerWebserviceUrl.trim().isEmpty()) {
            this.logger.debug((Object)"This is neptune running the filter. DB is accessed directly.");
            this.isNeptune = true;
        } else {
            this.isNeptune = false;
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

