/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.persist;

public class SearchMetadata {
    private Integer startRecord;
    private Integer maxRecordCount;
    private String sortField;
    private SortOrder sortOrder = SortOrder.Ascending;

    public SearchMetadata() {
    }

    public SearchMetadata(Integer startRecord, Integer maxRecordCount, String sortField, SortOrder sortOrder) {
        this.setStartRecord(startRecord);
        this.setMaximumRecordCount(maxRecordCount);
        this.setSortField(sortField);
        this.setSortOrder(sortOrder);
    }

    public Integer getMaximumRecordCount() {
        return this.maxRecordCount;
    }

    public void setMaximumRecordCount(Integer recordCount) {
        if (this.maxRecordCount != null && this.maxRecordCount < 1) {
            throw new IllegalArgumentException("maxRecordCount must be greater than 0.");
        }
        this.maxRecordCount = recordCount;
    }

    public Integer getStartRecord() {
        return this.startRecord;
    }

    public void setStartRecord(Integer startRecord) {
        if (startRecord != null && startRecord < 0) {
            throw new IllegalArgumentException("startRecord must be greater than or equal to 0.");
        }
        this.startRecord = startRecord;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        if (sortOrder == null) {
            sortOrder = SortOrder.Ascending;
        }
        this.sortOrder = sortOrder;
    }

    public String toString() {
        return "[start: " + this.getStartRecord() + ", count: " + this.getMaximumRecordCount() + ", sort: " + this.getSortField() + " order: " + (Object)((Object)this.getSortOrder()) + "]";
    }

    public static enum SortOrder {
        Ascending,
        Descending;

    }
}

