/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.util;

import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class OAuthHandler {
    private static String url = "http://localhost";
    private static String username = "admin";
    private static String password = "admin";
    private static String loginPage = "";
    private static String charset = "UTF-8";
    private static String loginAction = "";
    private static boolean loggedIn = false;
    private static String accessToken = null;
    private static CookieManager manager = new CookieManager(null, CookiePolicy.ACCEPT_ALL);

    public static void initialize(String url, String username, String password, String loginPage) throws UnsupportedEncodingException {
        OAuthHandler.url = url;
        OAuthHandler.username = username;
        OAuthHandler.password = password;
        OAuthHandler.loginPage = loginPage;
        loginAction = "login.do?j_username=" + URLEncoder.encode(OAuthHandler.username, charset) + "&" + "j_password=" + URLEncoder.encode(OAuthHandler.password, charset) + "&" + "login=" + URLEncoder.encode("Log In", charset);
    }

    public static CookieHandler login() throws Exception {
        CookieHandler oldHandler = CookieHandler.getDefault();
        try {
            CookieHandler.setDefault(manager);
            manager.getCookieStore().removeAll();
            String method = "GET";
            HttpURLConnection originalRequestConnection = OAuthHandler.getSSLconnection(url, method, loginPage);
            originalRequestConnection.connect();
            String redirectLocation = "";
            while (originalRequestConnection.getResponseCode() / 100 == 3) {
                redirectLocation = originalRequestConnection.getHeaderField("Location");
                originalRequestConnection = OAuthHandler.getSSLconnection(redirectLocation, method, "");
                originalRequestConnection.connect();
            }
            if (originalRequestConnection.getResponseCode() != 200) {
                throw new Exception("Did not redirect to OAuth Login correctly. Received : " + originalRequestConnection.getResponseCode() + "    -    " + originalRequestConnection.getResponseMessage());
            }
            method = "POST";
            HttpURLConnection loginConnection = OAuthHandler.getSSLconnection(redirectLocation.replace("login.jsp", loginAction), method, "");
            loginConnection.connect();
            while (loginConnection.getResponseCode() / 100 == 3) {
                redirectLocation = loginConnection.getHeaderField("Location");
                loginConnection = OAuthHandler.getSSLconnection(redirectLocation, method, "");
                OAuthHandler.setAccessToken(loginConnection);
                loginConnection.connect();
            }
            if (loginConnection.getResponseCode() != 200) {
                throw new Exception("Did not login correctly. Received : " + loginConnection.getResponseCode() + "    -    " + loginConnection.getResponseMessage());
            }
            if (!loginConnection.getURL().toString().contains(url + loginPage)) {
                throw new Exception("User Authentication Unsuccessful.");
            }
            loggedIn = true;
            CookieManager cookieManager = manager;
            return cookieManager;
        }
        catch (Exception e) {
            loggedIn = false;
            throw e;
        }
        finally {
            CookieHandler.setDefault(oldHandler);
        }
    }

    public static void logout() throws Exception {
        CookieHandler oldHandler = CookieHandler.getDefault();
        try {
            CookieHandler.setDefault(manager);
            String method = "POST";
            HttpURLConnection providerLogoutConnection = OAuthHandler.getSSLconnection(url, method, "?logoutsrc=logoutbutton");
            providerLogoutConnection.connect();
            String redirectLocation = "";
            while (providerLogoutConnection.getResponseCode() / 100 == 3) {
                redirectLocation = providerLogoutConnection.getHeaderField("Location");
                providerLogoutConnection = OAuthHandler.getSSLconnection(redirectLocation, method, "");
                providerLogoutConnection.connect();
            }
            if (providerLogoutConnection.getResponseCode() != 200) {
                throw new Exception("Did not process logout message correctly. Received : " + providerLogoutConnection.getResponseCode() + "    -    " + providerLogoutConnection.getResponseMessage());
            }
            if (!providerLogoutConnection.getURL().toString().contains("/provider/login.jsp")) {
                throw new Exception("Did not logout correctly. Was redirected to: " + providerLogoutConnection.getURL().toString());
            }
            loggedIn = false;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CookieHandler.setDefault(oldHandler);
        }
    }

    private static HttpURLConnection getSSLconnection(String ip, String method, String entryPage) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        URL url = entryPage != null && !entryPage.isEmpty() ? new URL(ip + entryPage) : new URL(ip);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod(method);
        return conn;
    }

    public static CookieManager getManager() {
        return manager;
    }

    public static boolean isLoggedIn() {
        return loggedIn;
    }

    public static boolean isUserLoggedIn(String username, String password) {
        return username.equals(OAuthHandler.username) && password.equals(OAuthHandler.password) && loggedIn;
    }

    public static String getAccessToken() {
        return loggedIn ? accessToken : null;
    }

    private static void setAccessToken(HttpURLConnection connection) {
        String query = connection.getURL().getQuery();
        if (null != query && query.contains("access_token")) {
            accessToken = query.replace("access_token=", "");
            accessToken = (accessToken = accessToken.substring(0, accessToken.indexOf("&"))).length() == 36 ? accessToken : null;
        }
    }
}

