/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.validation;

import com.tandbergtv.neptune.configuration.settings.util.ValidationMessageHelper;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.List;

public class SettingValidationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private List<ValidationResult> validationErrors;

    public SettingValidationException(List<ValidationResult> errors) {
        this.validationErrors = errors;
    }

    public SettingValidationException(ValidationResult error) {
        this.validationErrors = new ArrayList<ValidationResult>();
        this.validationErrors.add(error);
    }

    public List<ValidationResult> getValidationErrors() {
        return this.validationErrors;
    }

    public String getValidationErrorsAsJSON() {
        StringBuffer errosJSON = new StringBuffer();
        List<String> erros = ValidationMessageHelper.formatErrorMessages(this.validationErrors);
        errosJSON.append("{\"Errors\": { \"Error\":[ \n ");
        for (String error : erros) {
            errosJSON.append("\"");
            errosJSON.append(error);
            errosJSON.append("\",");
        }
        errosJSON.append("]}}");
        return errosJSON.toString().replace(",]", "]");
    }

    @Override
    public String getMessage() {
        return ValidationMessageHelper.formatErrorMessages(this.validationErrors).toString();
    }
}

