package com.tandbergtv.neptune.ui.realm.client.settings.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.RealmComponentPermissions;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiComplexSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingDefinition;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingGroup;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * 		Complex settings UI. Created based on metadata provided by the user.
 * 
 * @author Francisco Bento da Silva Neto
 *
 */
public class ComplexSettingsUI implements SettingsFormUI {

	private RealmConstants constants = GWT.create(RealmConstants.class);
	
	
	//private static final String HELP_ICON = "realm/images/help.png";
	private static final String HELP_ICON = "realm/images/information_black_16px.svg";
	private static final String CLOSE_ICON = "realm/images/X_black_16px.svg";
	
	private static final String RESTART_ICON = "realm/images/restart.png";

	private static final String PATH_SEPARATOR = ".";
	
	private UiSettingGroup settingGroup;
	private Map<String, String> settingsValues;
	private Map<String, String> originalValues;
	private List<SettingsInputWidgetWrapper> inputWidgets;
	private Map<String, RoundedDisclosureContainer> panelMap = new HashMap<String, RoundedDisclosureContainer>();
	private UiComplexSetting rootSetting;
	
	private boolean restartRequired = false;
	
	private Map<String,Integer> arrayLength = new HashMap<String, Integer>();
	private SettingsLazyView view = null;
	
	public ComplexSettingsUI(SettingsLazyView view) {
		this.view = view;
	}

	public int getComplexSettingArrayLength(String path) {
		Integer length = arrayLength.get(path);
		if (length == null) {
			length = 0;
			arrayLength.put(path, length);
		}
		return arrayLength.get(path);
	}
	
	public void buildComplexSettingArrayLength() {
		for (String key : settingsValues.keySet()) {
			int i = key.indexOf("[", 0); 
			
			while (i != -1) {
				String varPath = key.substring(0, i);
				
				Integer length = arrayLength.get(varPath);
				if (length == null) {
					length = 0;
					arrayLength.put(varPath, length);
				}
				String arrayIndexStr = key.substring(i+1, key.indexOf("]", i));
				int arrayIndex = Integer.parseInt(arrayIndexStr);
				int arraySize = arrayIndex + 1;

				if (arraySize > length) {
					arrayLength.put(varPath, arraySize);
				}

				i = key.indexOf("[", i+1); 
			}

		}
	}
	
	public void incrementComplexSettingArrayLength(String path) {
		Integer length = getComplexSettingArrayLength(path);
		length++;
		arrayLength.put(path, length);
	}

	public void decrementComplexSettingArrayLength(String path) {
		Integer length = getComplexSettingArrayLength(path);
		length--;
		arrayLength.put(path, length);
	}
	
	public RoundedDisclosureContainer createGrouppedForm(
			UiComplexSetting parent, String path, boolean isFirstLevel) {
		RoundedDisclosureContainer settingPanel = createSection(parent, path);
		VerticalContainer settingPanelContainer = (VerticalContainer) settingPanel.getContent();
		
		FormContainer formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
		List<UiComplexSetting> complexSettings = new ArrayList<UiComplexSetting>();
		
		
		//for (UiSettingDefinition setting : parent.getSettings()) {
		for (final UiSettingDefinition setting : parent.getSettings()) {
	
			if (setting instanceof UiComplexSetting) {
				complexSettings.add((UiComplexSetting) setting);
			} else {
				String settingName = path + PATH_SEPARATOR + setting.getName();
				
				boolean showFields = true;
				
				String pathNoIndex = path;
				int braceIndex = path.lastIndexOf("[");
				if (braceIndex >= 0) {
					pathNoIndex = path.substring(0, braceIndex);
				}
				
				int length = getComplexSettingArrayLength(pathNoIndex);
				if (length == 0) {
					if (parent.getMin() == null) {
						showFields = false;
					} else {
						incrementComplexSettingArrayLength(pathNoIndex);
					}
				}
				if (parent == rootSetting) {
					showFields = true;
				}
				if (showFields) {
					HorizontalContainer fieldContainer = new HorizontalContainer();
					
					LabelWidget label = new LabelWidget(LocalizedSettingUtil.toLocalizedString(setting.getDisplayName()));
					
					ImageWidget helpIcon = new ImageWidget(HELP_ICON);
					helpIcon.setTitle(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
					helpIcon.addStyleName("SettingsUiHelpIcon");
					
					final LabelWidget helpWidget = new LabelWidget();
					helpIcon.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent event) {
							helpWidget.setVisible(true);
							helpWidget.setText(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
							helpWidget.addStyleName("SettingsUiHelpText");
						}
					});
					//LabelWidget helpWidget = new LabelWidget(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
					//helpWidget.addStyleName("SettingsUiHelpText");
					
					boolean isRequired = setting.getRequired();
					
					SettingsInputWidgetWrapper widgetWrapper = SettingsWidgetFactory.getWidgetFor(setting, settingsValues.get(settingName));
					fieldContainer.add(widgetWrapper.createInputWidget());
					if (setting.isRestartRequired()) {
						ImageWidget restartIcon = new ImageWidget(RESTART_ICON);
						restartIcon.setTitle(constants.settingRequiresRestart());
						restartIcon.addStyleName("SettingsUiHelpIcon");
						fieldContainer.add(restartIcon);
					}
					fieldContainer.add(helpIcon);
					fieldContainer.add(helpWidget);
				
					widgetWrapper.setSettingName(settingName);
	
					formContainer.addRow(label, fieldContainer.asWidget(), isRequired);
					inputWidgets.add(widgetWrapper);
				}
			}
		}
		// Form isnt empty.
		if (formContainer.getFieldCount() > 0) {
			settingPanelContainer.add(formContainer);
		}
		
		for (UiComplexSetting complexSetting : complexSettings) {
			String childPath = path + PATH_SEPARATOR + complexSetting.getName();
			
			int sectionsToCreate = 1;

			if (complexSetting.getMax() == null || complexSetting.getMax() > 1) {
				sectionsToCreate = getComplexSettingArrayLength(childPath);
				
				sectionsToCreate = Math.max(sectionsToCreate, 1);
				
				if (complexSetting.getMin() != null && complexSetting.getMin() > 1) {
					if (sectionsToCreate < complexSetting.getMin()) {
						sectionsToCreate = complexSetting.getMin();
					}
				}
			}
			
			for (int i = 0; i < sectionsToCreate; i++) {
				String childIndexedPath = childPath;
				if (complexSetting.getMax() == null || complexSetting.getMax() > 1) {
					childIndexedPath+= "[" + i + "]";
				}
				 settingPanelContainer.add(createGrouppedForm(complexSetting,
						childIndexedPath, false));
				
			}
		}
		if (isFirstLevel) {
			HorizontalContainer buttonsContainer = new HorizontalContainer();
			buttonsContainer.add(getSaveButton());
			buttonsContainer.add(getCancelButton());
			buttonsContainer.addStyleName(StyleNames.STYLE_CMS_BUTTON_CONTAINER);
			settingPanelContainer.add(buttonsContainer);
		}
				
		return settingPanel;
	}
	
	private ButtonWidget getSaveButton(){
		ButtonWidget btnSave = new ButtonWidget(constants.saveButton());
		
		btnSave.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		btnSave.addStyleName(StyleNames.STYLE_EB_BTN);
		btnSave.addStyleName(StyleNames.STYLE_EB_BTN_COLOR_GREEN);
		btnSave.addStyleName(StyleNames.STYLE_SAVE_BUTTON_ICON);

		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.SETTINGS_MODIFY)) {
			btnSave.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					view.clearErrors();
					view.saveSettings();
				}
			});
		}
		btnSave.setVisible(ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.SETTINGS_MODIFY));
	
		
		return btnSave;
	}
	
	private ButtonWidget getCancelButton(){
		
		ButtonWidget btnCancel = new ButtonWidget(constants.cancelButton());
		btnCancel.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		btnCancel.addStyleName(StyleNames.STYLE_EB_BTN);
			
		btnCancel.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				view.clearErrors();
				view.settingsTree.setSelectedItem(null);
				view.clearEditorForm();
				originalValues = null;
			}
		});
		btnCancel.setVisible(ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.SETTINGS_MODIFY));
		
		return btnCancel;
		
	}
	
	public Widget createRoot() {
		UiComplexSetting setting = (UiComplexSetting) settingGroup.getSettings().get(0);
		rootSetting = setting;
		return createGrouppedForm(setting, setting.getName(), true);
	}
	
	private RoundedDisclosureContainer createSection(final UiComplexSetting setting,
													 final String path) {
		
		// if panel is already created, just returns it.
		if (panelMap.get(path) != null) {
			return panelMap.get(path); 
		}
		
		HorizontalContainer header = new HorizontalContainer();
		header.setWidth("100%");
		
		HorizontalContainer headerLabels = new HorizontalContainer();
		LabelWidget label = new LabelWidget(LocalizedSettingUtil.toLocalizedString(setting.getDisplayName()));
		headerLabels.add(label);
		
		ImageWidget helpIcon = new ImageWidget(HELP_ICON);
		helpIcon.setTitle(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
		helpIcon.addStyleName("SettingsUiHelpIcon");
		
		final LabelWidget helpWidget = new LabelWidget();
		helpWidget.setVisible(false);
		
		
//		LabelWidget helpWidget = new LabelWidget(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
//		helpWidget.addStyleName("SettingsUiHelpText");

		if (setting.isRestartRequired()) {
			ImageWidget restartIcon = new ImageWidget(RESTART_ICON);
			restartIcon.setTitle(constants.settingRequiresRestart());
			restartIcon.addStyleName("SettingsUiHelpIcon");
			headerLabels.add(restartIcon);
		}
		
		
		headerLabels.add(helpIcon);
		headerLabels.add(helpWidget);
		
		header.add(headerLabels);

		HorizontalContainer headerButtons = new HorizontalContainer();
		
		header.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		header.add(headerButtons);
		final RoundedDisclosureContainer complexPanel = new RoundedDisclosureContainer(header);
		
		helpIcon.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				helpWidget.setVisible(true);
				helpWidget.setText(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
				
				helpWidget.addStyleName("SettingsUiHelpText");			
				if(complexPanel.isOpen()==false){
					complexPanel.setOpen(true);
				}else if(complexPanel.isOpen()==true){
					complexPanel.setOpen(false);
				}
				
				
				
			}
		});
		complexPanel.setTitle(path);
		
		if (setting != rootSetting) {
			if (setting.getMax() == null || setting.getMax() > 1) {
				ButtonWidget add = new ButtonWidget();
				add.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
				add.addStyleName(StyleNames.STYLE_EB_BTN);
				add.addStyleName(StyleNames.STYLE_PLUS_BUTTON_ICON);
				add.setText("+");
				headerButtons.add(add);
				
				add.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						event.stopPropagation();
						String fullPath = complexPanel.getTitle();
						String pathNoBrackets = fullPath.substring(0, fullPath.lastIndexOf("["));
						int length = getComplexSettingArrayLength(pathNoBrackets);
						if (setting.getMax() == null || setting.getMax() >= (length+1)) {
							String indexedPath = pathNoBrackets + "[" + length + "]";
							incrementComplexSettingArrayLength(pathNoBrackets);
							RoundedDisclosureContainer parentPanel = panelMap.get(getParentPath(fullPath));
							
							VerticalContainer container = (VerticalContainer) parentPanel.getContent();
							
							RoundedDisclosureContainer newGroup = createGrouppedForm(
									setting, indexedPath, false);
							int panelPosition = -1;
							for(int i = 0; i < container.getWidgetCount(); i++) {
								if (container.getWidget(i) instanceof RoundedDisclosureContainer) {
									RoundedDisclosureContainer section = (RoundedDisclosureContainer) container.getWidget(i);
									if (section.getTitle().startsWith(pathNoBrackets)) {
										panelPosition = i;										
									}
								}
							}
							if (panelPosition == -1) {
								panelPosition = container.getWidgetCount();
							}
							panelPosition++;
							if (panelPosition == container.getWidgetCount()) {
								container.add(newGroup);
							} else {
								container.add(newGroup);
								for (int i = panelPosition; i < container.getWidgetCount() - 1; i++) {
									Widget w = container.getWidget(panelPosition);
									container.remove(panelPosition);
									container.add(w);
								}
							}
						}
					}
				});
				
				ButtonWidget remove = new ButtonWidget();
				remove.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
				remove.addStyleName(StyleNames.STYLE_EB_BTN);
				remove.addStyleName(StyleNames.STYLE_MINUS_BUTTON_ICON);
				remove.setText("-");
				headerButtons.addStyleName(StyleNames.STYLE_CMS_BUTTON_CONTAINER);
				headerButtons.add(remove);
				
				remove.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						event.stopPropagation();

						int min = 0;
						if (setting.getMin() != null) {
							min = setting.getMin();
						}
						String fullPath = complexPanel.getTitle();
						String pathNoBrackets = fullPath.substring(0, fullPath.lastIndexOf("["));
						int size = getComplexSettingArrayLength(pathNoBrackets);
						if (size > min) {
							
							if (size == 1) {
								// is the last item. removes just the fields, keep the disclosure container for the +/- buttons.
								VerticalContainer container = (VerticalContainer) complexPanel.getContent();
								for (int i = 0; i < container.getWidgetCount(); i++) {
									container.remove(i);
								}
							} else {
								// removes the widget and its children from the parent container
								RoundedDisclosureContainer parentPanel = panelMap.get(getParentPath(fullPath));
								for (Iterator<String> i = panelMap.keySet().iterator(); i.hasNext();) {
									String key = i.next();
									if (key.startsWith(fullPath)) {
										i.remove();
									}
								}
								VerticalContainer container = (VerticalContainer) parentPanel.getContent();
								container.remove(complexPanel);
							}
							// removes the input widgets from the list
							for (Iterator<SettingsInputWidgetWrapper> i = inputWidgets.iterator(); i.hasNext();) {
								SettingsInputWidgetWrapper widget = i.next();
								if (widget.getSettingName().startsWith(fullPath)) {
									i.remove();
								}
							}
							
							String indexStr = fullPath.substring(fullPath.lastIndexOf("[") + 1, fullPath.length() - 1);
							int removedIndex = Integer.parseInt(indexStr);
							
							// rename widgets to keep the index
							Map<String, RoundedDisclosureContainer> newPanelMap = new HashMap<String, RoundedDisclosureContainer>(panelMap);
							for (SettingsInputWidgetWrapper widget : inputWidgets) {
								String widgetName = widget.getSettingName();
								int braceStartIndex = widgetName.indexOf(pathNoBrackets);
								if (braceStartIndex >= 0) {
									int braceCloseIndex = widgetName.indexOf("]", pathNoBrackets.length());
									
									String currentIndexStr = widgetName.substring(pathNoBrackets.length() + 1, braceCloseIndex);
									int currentIndex = Integer.parseInt(currentIndexStr);
									
									if (currentIndex > removedIndex) {
										String oldGroupName = pathNoBrackets + "[" + currentIndex + "]";
										currentIndex--;
										String newGroupName = pathNoBrackets + "[" + currentIndex + "]"; 
										String newSettingName = newGroupName + widgetName.substring(braceCloseIndex + 1);
										widget.setSettingName(newSettingName);										
										
										RoundedDisclosureContainer panel = panelMap.get(oldGroupName);
										if (panel != null) {
											panel.setTitle(newGroupName);
											newPanelMap.put(newGroupName, panel);
										}

									}

								}
							}
							if (size != 1) {
								// remove the last panel from the map
								String oldGroupName = pathNoBrackets + "[" + (getComplexSettingArrayLength(pathNoBrackets) -1) + "]";
								newPanelMap.remove(oldGroupName);
							}
							
							panelMap = newPanelMap;
							
							decrementComplexSettingArrayLength(pathNoBrackets);
						}
					}
				});
			}
		}

		VerticalContainer contents = new VerticalContainer();
		contents.setWidth("100%");

		complexPanel.add(contents);
		complexPanel.setOpen(true);
		complexPanel.setWidth("100%");
		
		panelMap.put(path, complexPanel);
		
		return complexPanel;
	}
	
	protected String getParentPath(String settingPath) {
		return settingPath.substring(0, settingPath.lastIndexOf(PATH_SEPARATOR));
	}

	public Widget createUI() {
		return createRoot();
	}
	
	public void setSettingGroup(UiSettingGroup settingGroup) {
		this.settingGroup = settingGroup;
		this.inputWidgets = new ArrayList<SettingsInputWidgetWrapper>(settingGroup.getSettings().size());
	}
	
	public UiSettingGroup getSettingGroup() {
		return settingGroup;
	}

	public void setSettingsValues(Map<String, String> settingsValues) {
		this.settingsValues = settingsValues;
		buildComplexSettingArrayLength();
		if (originalValues == null) {
			originalValues = deepClone(this.settingsValues);
		}
	}
	
	private Map<String, String> deepClone(Map<String, String> map) {
		Map<String, String> clone = new HashMap<String, String>();
		Iterator<String> it = map.keySet().iterator();

		while (it.hasNext()) {
			String key = it.next();
			String value = map.get(key);
			clone.put(key, value);
		}
		return clone;
	}
	
	public Map<String, String> applyChanges() {
		Map<String, String> changedSettings = this.getWidgetsKeyValues();
		
		if (rootSetting.isRestartRequired()) {
			restartRequired = !changedSettings.equals(settingsValues);
		}
		
		return changedSettings;
	}

	
	public void resetOriginalValues() {
		originalValues = deepClone(this.getWidgetsKeyValues());
	}
	
	@SuppressWarnings("unchecked")
	public boolean haveSettingsChanged() {
		
		Map<String, String> inputs = this.getWidgetsKeyValues();
		Iterator itr = inputs.entrySet().iterator();
		while (itr.hasNext()) {
			Map.Entry<String, String> entry = (Map.Entry) itr.next();
			if (originalValues != null) {
				if (entry.getValue() != null
						&& !entry.getValue().isEmpty()) {
					if (originalValues.get(entry.getKey()) != null) {
						if (!originalValues.get(entry.getKey()).equals(
								entry.getValue())) {
							return true;
						}
					} else {
						return true;
					}
				}
			}
		}
        return false;

	}
	
	/**
	 * Wrap the input key:values from the widgets in a map and return
	 * 
	 * @return
	 */
	private Map<String, String> getWidgetsKeyValues() {

		Map<String, String> changedSettings = new HashMap<String, String>();
		for (SettingsInputWidgetWrapper input : inputWidgets) {
			changedSettings
					.put(input.getSettingName(), input.getValue());
		}
        return changedSettings;
	}
	
	@Override
	public boolean requiresRestart() {
		return restartRequired;
	}
	
}
