package com.tandbergtv.neptune.ui.realm.client.tab.role;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

public class ModuleRecord implements Record<Long> {
	
	private static final String VIEW_PERM = "View";
	private static final String CREATE_PERM = "Create";
	private static final String MODIFY_PERM = "Modify";
	private static final String DELETE_PERM = "Delete";
	
	private UiModule mod;
	private UiPermission viewPerm;
	private UiPermission createPerm;
	private UiPermission modifyPerm;
	private UiPermission deletePerm;
	private List<UiPermission> otherPerms;
	
	public ModuleRecord( UiModule uiModule ) {
		mod = uiModule;
		
		initPerms();
	}
	
	private void initPerms() {
		if( otherPerms == null ) {
			otherPerms = new ArrayList<UiPermission>();
		} else {
			otherPerms.clear();			
		}
		
		for( UiPermission p : mod.getPermissions() ) {
			String pName = p.getDisplayName();
			if( pName.equals(VIEW_PERM) ) {
				viewPerm = p;
			} else if ( pName.equals(CREATE_PERM) ) {
				createPerm = p;
			} else if ( pName.equals(MODIFY_PERM) ) {
				modifyPerm = p;
			} else if ( pName.equals(DELETE_PERM) ) {
				deletePerm = p;
			} else {
				otherPerms.add(p);
			}
		}
		
	}
	
	public UiPermission getViewPerm() {
		return viewPerm;
	}
	
	public UiPermission getCreatePerm() {
		return createPerm;
	}
	public UiPermission getModifyPerm() {
		return modifyPerm;
	}
	public UiPermission getDeletePerm() {
		return deletePerm;
	}
	public List<UiPermission> getOtherPerms() {
		return otherPerms;
	}
	
	
	public String getDisplayName() {
		return mod.getDisplayName();
	}
	
	public void setUiModule( UiModule uiModule ) {
		mod = uiModule;
	}
	
	public UiModule getUiModule() {
		return mod;
	}
	
	@Override
	public Long getKey() {
		return mod.getId();
	}
}
