/*
 * Created on Feb 8, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.dnd;

/**
 * Event Handler for the table row drag and drop events to trigger a move of the table row
 * 
 * @author Vijay Silva
 */
public interface TableRowMoveHandler {

	/**
	 * Called before the table row has moved but after the row has been dropped to the target
	 * location.
	 * 
	 * @param event The event
	 */
	void onBeforeRowMove(TableRowBeforeMoveEvent event);

	/**
	 * Called after the table row is moved
	 * 
	 * @param event The event
	 */
	void onRowMove(TableRowMoveEvent event);
}
