package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import java.util.Date;

import com.google.gwt.user.datepicker.client.CalendarModel;

/**
 *      Custom Model just to fix the default time that will be shown when the user sets the Date for the first time.
 *       
 * @author <a href="mailto:francisco.neto@venturus.org.br">xfranet - Francisco Bento</a>
 *
 */
public class CustomCalendarModel extends CalendarModel {

    /**
     * Overwrites the CalendarModel.getCurrentFirstDayOfFirstWeek() to set the default Hour to 0, instead of 12.
     * 
     * @return Date
     */
    @SuppressWarnings("deprecation") // GWT requires Date
    @Override
    public Date getCurrentFirstDayOfFirstWeek() {
        // Get the date defined by GWT and overwrites the hour to 0, instead of 12.
        Date date = super.getCurrentFirstDayOfFirstWeek();
        // Using the deprecated method cause the GWT code is using the same method on:
        // com.google.gwt.user.datepicker.client.CalendarUtil.resetTime(Date date)
        date.setHours(0);
        return date;
    }
}
