/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.clustermgmt;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.config.TcpIpConfig;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class HazelcastConfig {
    private static final String HAZELCAST_XML_CONFIG_PATH = "xml.config.path";
    private static final String HAZELCAST_DISCOVERY_TYPE = "discovery.type";
    private static final String HAZELCAST_MULTICAST_GROUP = "multicast.ip";
    private static final String HAZELCAST_MULTICAST_PORT = "multicast.port";
    private static final String HAZELCAST_TCPIP_HOSTS = "tcpip.hosts";
    private static final String HAZELCAST_HOST_IP = "host.ip";
    private static final String HAZELCAST_PORT = "hazelcast.port";
    private static final String HAZELCAST_CLUSTER_NAME = "cluster.name";
    private static final String HAZELCAST_CLUSTER_PASSWORD = "cluster.password";
    private static final String HAZELCAST_INITIAL_WAIT = "initial.wait";
    private static final Logger log = Logger.getLogger(HazelcastConfig.class);

    private HazelcastConfig() {
    }

    public static Config create(Properties properties) throws IOException {
        System.setProperty("hazelcast.logging.type", "log4j");
        String xmlPath = properties.getProperty(HAZELCAST_XML_CONFIG_PATH);
        if (xmlPath != null) {
            FileSystemXmlConfig cfg = new FileSystemXmlConfig(xmlPath);
            return cfg;
        }
        Config config = new Config();
        HazelcastConfig.configurePort(config, properties);
        HazelcastConfig.configureClusterDiscovery(config, properties);
        HazelcastConfig.configureClusterHost(config, properties);
        HazelcastConfig.configureClusterName(config, properties);
        HazelcastConfig.configureInitialWait(config, properties);
        return config;
    }

    private static void configurePort(Config config, Properties properties) {
        String port = properties.getProperty(HAZELCAST_PORT);
        if (port == null || "".equals(port.trim())) {
            log.warn((Object)"Hazelcast port is not provided so system will use default port[5950], please check value for key[hazelcast.port] in file /opt/tandbergtv/cms/conf/neptune/cluster.properties");
            port = "5950";
        }
        log.debug((Object)("using hazelcast port[" + port + "]"));
        config.setPort(Integer.parseInt(port));
        config.setPortAutoIncrement(false);
    }

    private static void configureInitialWait(Config config, Properties properties) throws IOException {
        String wait = properties.getProperty(HAZELCAST_INITIAL_WAIT);
        if (wait != null) {
            config.setProperty("hazelcast.initial.wait.seconds", wait);
        }
    }

    private static void configureClusterName(Config config, Properties properties) throws IOException {
        String password;
        String name = properties.getProperty(HAZELCAST_CLUSTER_NAME);
        if (name != null) {
            log.debug((Object)("Cluster name " + name));
            config.getGroupConfig().setName(name);
        }
        if ((password = properties.getProperty(HAZELCAST_CLUSTER_PASSWORD)) != null) {
            config.getGroupConfig().setPassword(password);
        }
    }

    private static void configureClusterHost(Config config, Properties properties) throws IOException {
        config.getNetworkConfig().getInterfaces().clear();
        String host = properties.getProperty(HAZELCAST_HOST_IP);
        if (host != null && !host.trim().equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(host, ",;");
            while (stringTokenizer.hasMoreElements()) {
                String token = stringTokenizer.nextElement().toString().trim();
                if (token.length() <= 0) continue;
                config.getNetworkConfig().getInterfaces().addInterface(token);
            }
            log.debug((Object)("Cluster host " + host));
            config.getNetworkConfig().getInterfaces().setEnabled(true);
        }
    }

    private static void configureClusterDiscovery(Config config, Properties properties) {
        String discoveryType = properties.getProperty(HAZELCAST_DISCOVERY_TYPE);
        log.info((Object)("Hazelcast discovery type: " + discoveryType));
        if ("tcpip".equalsIgnoreCase(discoveryType)) {
            HazelcastConfig.configureTcpIpDiscovery(config, properties);
        } else if ("multicast".equalsIgnoreCase(discoveryType)) {
            HazelcastConfig.configureMulticastDiscovery(config, properties);
        } else {
            log.warn((Object)("Invalid cluster discovery type: " + discoveryType + ". Supported values are MULTICAST and TCPIP."));
            log.warn((Object)"Will use multicast discovery.");
            HazelcastConfig.configureMulticastDiscovery(config, properties);
        }
    }

    private static void configureMulticastDiscovery(Config config, Properties properties) {
        String port;
        log.info((Object)"Configuring multicast cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
        String ip = properties.getProperty(HAZELCAST_MULTICAST_GROUP);
        if (ip != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastGroup(ip);
            log.info((Object)("Cluster multicast group: " + ip));
        }
        if ((port = properties.getProperty(HAZELCAST_MULTICAST_PORT)) != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(Integer.parseInt(port));
            log.info((Object)("Cluster multicast port: " + port));
        }
    }

    private static void configureTcpIpDiscovery(Config config, Properties properties) {
        log.info((Object)"Configuring TCP/IP cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
        TcpIpConfig tcpip = config.getNetworkConfig().getJoin().getTcpIpConfig();
        String hosts = properties.getProperty(HAZELCAST_TCPIP_HOSTS);
        if (hosts != null) {
            StringTokenizer tkz = new StringTokenizer(hosts, ",; ");
            while (tkz.hasMoreTokens()) {
                String host = tkz.nextToken();
                try {
                    log.info((Object)("Adding host: " + host));
                    tcpip.addMember(host);
                }
                catch (Exception ex) {
                    log.error((Object)("Could not add host: " + host), (Throwable)ex);
                }
            }
        }
    }
}

