/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JobScheduler {
    private ScheduledThreadPoolExecutor executor;

    public JobScheduler(int size) {
        this.executor = new ScheduledThreadPoolExecutor(size);
    }

    public void start() {
        this.executor.prestartCoreThread();
    }

    public Future<?> schedule(Runnable runnable, long delay, long period) {
        return this.executor.scheduleAtFixedRate(runnable, delay, period, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    public void purge() {
        this.executor.purge();
    }

    public ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }
}

