/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ldap;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LdapContextFactory {
    protected final Hashtable<String, String> environment = new Hashtable();
    protected final Control[] connectionControls;
    private static final String DEFAULT_CONTEXT_FACTORY_CLASS = "com.sun.jndi.ldap.LdapCtxFactory";

    protected LdapContextFactory(Map<String, String> defaultEnvironment, Control[] connectionControls) {
        this.environment.put("java.naming.factory.initial", DEFAULT_CONTEXT_FACTORY_CLASS);
        for (String key : defaultEnvironment.keySet()) {
            String value = defaultEnvironment.get(key);
            if (key == null || value == null) continue;
            this.environment.put(key, value);
        }
        this.connectionControls = connectionControls;
    }

    public static LdapContextFactory newInstance(Map<String, String> defaultEnvironment) {
        return new LdapContextFactory(defaultEnvironment, null);
    }

    public static LdapContextFactory newInstance(Map<String, String> defaultEnvironment, Control[] connectionControls) {
        return new LdapContextFactory(defaultEnvironment, connectionControls);
    }

    public LdapContext newLdapContext() throws NamingException {
        return new InitialLdapContext(this.getEnvironment(), this.connectionControls);
    }

    public LdapContext newLdapContext(Map<String, String> overrideEnvironment) throws NamingException {
        Hashtable<String, String> contextEnvironment = this.getEnvironment();
        for (String key : overrideEnvironment.keySet()) {
            if (key == null) continue;
            String value = overrideEnvironment.get(key);
            if (value == null || value.isEmpty()) {
                contextEnvironment.remove(key);
                continue;
            }
            contextEnvironment.put(key, value);
        }
        return new InitialLdapContext(contextEnvironment, null);
    }

    private Hashtable<String, String> getEnvironment() {
        return new Hashtable<String, String>(this.environment);
    }
}

