/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.filter.AuthenticationException;
import com.ericsson.neptune.security.filter.Errors;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public abstract class BaseSecurityFilter
implements Filter {
    protected static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_LOGIN_URL = "neptune_sso_oauth2_provider_login_url";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_VALIDATE_URL = "neptune_sso_oauth2_provider_validate_url";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_LOGOUT_URL = "neptune_sso_oauth2_provider_logout_url";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_URLS_PROPERTIES = "neptune_sso_oauth2_provider_urls_properties";
    protected static final String NEPTUNE_SSO_OAUTH2_PROVIDER_WEBSERVICES_URL = "neptune_sso_webservice_url";
    protected static final String EXCLUDE_URLS = "exclude_url";
    protected static final String IS_NEPTUNE = "Neptune";
    protected static final String INVALID_CREDENTIALS_MSG = "Invalid user credentials";
    private static final String APPLICATION_XML = "application/xml";
    private static final String APPLICATION_JSON = "application/json";
    public static final String SSL_FINGERPRINT_HEADER = "X-SSL-Client-FINGERPRINT";
    protected Logger logger = Logger.getLogger(this.getClass());
    protected Properties providerUrls;
    private Set<String> excludedUrls;
    protected boolean isNeptune = false;

    public abstract void applyFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    public abstract void loadConfiguration(FilterConfig var1) throws ServletException;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isHttp(servletRequest, servletResponse)) {
            this.logger.debug((Object)(this.getClass().getName() + " not interrupting the request since either request or response is not of HTTP type"));
            this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.requestIsInExlcudesList(request)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        try {
            this.applyFilter(request, response, filterChain);
        }
        catch (AuthenticationException e) {
            String msg = e.getMessage() == null ? INVALID_CREDENTIALS_MSG : e.getMessage();
            String contentType = request.getHeader("Accept");
            this.buildResponse(response, msg, contentType);
            response.flushBuffer();
        }
        catch (IOException e1) {
            this.logger.error((Object)("An exception ocurred while trying to execute the filter " + this.getClass().getName()), (Throwable)e1);
            throw e1;
        }
        catch (ServletException e2) {
            this.logger.error((Object)("An exception ocurred while trying to execute the filter " + this.getClass().getName()), (Throwable)e2);
            throw e2;
        }
    }

    private void buildResponse(HttpServletResponse response, String msg, String contentType) throws IOException {
        response.setStatus(401);
        if (contentType != null && contentType.startsWith(APPLICATION_JSON)) {
            response.setContentType(APPLICATION_JSON);
            String json = "{ \"errors\": { \"error\": \"" + StringEscapeUtils.escapeJavaScript((String)msg) + "\" }}";
            response.getOutputStream().write(json.getBytes());
        } else {
            response.setContentType(APPLICATION_XML);
            try {
                Errors errors = new Errors();
                errors.getErrors().add(msg);
                StringWriter strWriter = new StringWriter();
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Errors.class});
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal((Object)errors, (Writer)strWriter);
                response.getOutputStream().write(strWriter.toString().getBytes());
            }
            catch (JAXBException e) {
                response.getOutputStream().write(("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?> <errors><error>" + msg + "</error></errors>").getBytes());
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.isNeptune = false;
        this.providerUrls = this.readProperties(config.getInitParameter(NEPTUNE_SSO_OAUTH2_PROVIDER_URLS_PROPERTIES));
        this.excludedUrls = this.readExcludedUrls(config.getInitParameter(EXCLUDE_URLS));
        if (config.getInitParameter(IS_NEPTUNE) != null) {
            this.isNeptune = true;
        }
        this.loadConfiguration(config);
    }

    public void destroy() {
        this.logger.debug((Object)"Destroy called - nothing to do in here!");
    }

    private Set<String> readExcludedUrls(String excludedUrlParameter) {
        if (excludedUrlParameter == null || excludedUrlParameter.trim().length() == 0) {
            return new HashSet<String>();
        }
        HashSet<String> result = new HashSet<String>();
        for (String url : excludedUrlParameter.split(",")) {
            if ((url = url.trim()).length() <= 0) continue;
            result.add(url);
        }
        return result;
    }

    private boolean requestIsInExlcudesList(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null) {
            return false;
        }
        for (String excludedUrl : this.excludedUrls) {
            if (!path.contains(excludedUrl)) continue;
            return true;
        }
        return false;
    }

    private boolean isHttp(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && response instanceof HttpServletResponse;
    }

    private Properties readProperties(String filePath) throws ServletException {
        if (filePath == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            File propertiesFile = new File(filePath);
            Properties result = new Properties();
            inputStream = new FileInputStream(propertiesFile);
            result.load(inputStream);
            Properties properties = result;
            return properties;
        }
        catch (FileNotFoundException e) {
            Properties properties = this.setDefaultProperties();
            return properties;
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not load properties files", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Can not close input stream for properties file", (Throwable)e);
                }
            }
        }
    }

    private Properties setDefaultProperties() {
        Properties result = new Properties();
        result.setProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_LOGIN_URL, "/provider/oauth/authorize");
        result.setProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_VALIDATE_URL, "https://localhost:8443/provider/oauth/validate");
        result.setProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_LOGOUT_URL, "/provider/logout");
        result.setProperty(NEPTUNE_SSO_OAUTH2_PROVIDER_WEBSERVICES_URL, "https://localhost:8443/cms/services/users/self");
        return result;
    }

    protected boolean isLogoutRequested(HttpServletRequest request, ServletResponse response) {
        String paramVal = request.getParameter("logoutsrc");
        return "logoutbutton".equalsIgnoreCase(paramVal);
    }
}

