/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;

public class TrustedSSLClientFilter
extends BaseSecurityFilter {
    private static final String SSL_FUNCTIONAL_USER_ID = "services";
    private static final String SSL_CONFIG_FILE = "ssl_trusted_file";
    private String sslConfigFile = "/var/lib/nobody/.cms_fingerprint";
    private String expectedFingerprint;

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            if (this.validateSSLClient((ServletRequest)request, (ServletResponse)response)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendError(401, "Untrusted client certificate");
            }
        }
        catch (ServletException se) {
            this.logger.error((Object)"Failed to validate SSL client. Responding with 500", (Throwable)se);
            response.sendError(500, "Failed to validate SSL client");
        }
    }

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        String scFile = config.getInitParameter(SSL_CONFIG_FILE);
        this.sslConfigFile = scFile == null || scFile.trim().length() == 0 ? this.sslConfigFile : scFile;
        this.readConfigAndCacheFingerprint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigAndCacheFingerprint() {
        String line = null;
        File f = new File(this.sslConfigFile);
        if (f.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(f));
                while ((line = br.readLine()) != null && (line.startsWith("#") || line.trim().length() <= 0)) {
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Fingerprint file not found. This environment wont be able to operate with Trusted SSL Clients");
                return;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        if (line == null) {
            this.logger.warn((Object)"Fingerprint file not found. This environment wont be able to operate with Trusted SSL Clients");
            return;
        }
        this.expectedFingerprint = line;
    }

    private boolean validateSSLClient(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException {
        String fingerPrint = ((HttpServletRequest)servletRequest).getHeader("X-SSL-Client-FINGERPRINT");
        if (fingerPrint == null || fingerPrint.trim().length() == 0) {
            return true;
        }
        boolean isTrusted = this.isTrustedClient(fingerPrint);
        if (isTrusted) {
            NeptunePrincipal principal = new NeptunePrincipal();
            principal.setUserName(SSL_FUNCTIONAL_USER_ID);
            ((HttpServletRequest)servletRequest).setAttribute("neptune_sso_oauth2_principal", (Object)principal);
        }
        return isTrusted;
    }

    private boolean isTrustedClient(String fingerPrint) throws ServletException {
        if (this.expectedFingerprint == null) {
            this.logger.debug((Object)"This environment is not configured to operate with Trusted SSL Clients");
            return false;
        }
        try {
            fingerPrint = "NeptuneComponent:" + fingerPrint + ":TrustedClient";
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = digest.digest(fingerPrint.getBytes());
            fingerPrint = DatatypeConverter.printHexBinary((byte[])bytes);
            if (this.expectedFingerprint.equalsIgnoreCase(fingerPrint)) {
                return true;
            }
            this.logger.debug((Object)"Invalid fingerprint, can not trust request, but continuing forward with rest of the filters.");
            return false;
        }
        catch (Exception e) {
            throw new ServletException("Failed to evaluate client reliability", (Throwable)e);
        }
    }
}

