/*
 * Created on Jan 25, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.ui.realm.client.tab.role;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Stores a Role Key
 * 
 * @author Vijay Silva
 */
public class UiRoleKey implements IsSerializable {

	private static final String ENTRY_SEPARATOR = ":::";

	private Long id;

	/**
	 * Default Constructor
	 */
	public UiRoleKey() {
	}

	/**
	 * Constructs a UiUserKey with the given ID and external key
	 * 
	 * @param id The role ID
	 * @param externalKey The external key
	 */
	public UiRoleKey(Long id) {
		this.id = id;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public boolean isValueAssigned() {
		return (id != null);
	}

	/*
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return (id != null) ? (id.hashCode() + 19) : super.hashCode();
	}

	/*
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;

		if (!(obj instanceof UiRoleKey))
			return false;

		/* IDs must be equal */
		UiRoleKey other = (UiRoleKey) obj;
		return (id != null && id.equals(other.id));
	}

	/*
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return (id == null) ? "" : id.toString();
	}

	/**
	 * Parse the string generated from the toString() method of UiUserKey to a UiUserKey object.
	 * 
	 * @param roleKey String representation of a UiUserKey
	 * @return The UiUserKey object parsed from the string
	 */
	public static UiRoleKey parse(String roleKey) {
		UiRoleKey result = new UiRoleKey();

		if (roleKey == null)
			throw new RuntimeException("Cannot parse null string to UiUserKey.");

		/*
		 * For backwards compatibility, assume entry separator can exist in string. Since external
		 * key is removed, the entry separator is no longer used. To support old bookmarks, continue
		 * to parse expecting the entry separator.
		 */
		String[] entries = roleKey.split(ENTRY_SEPARATOR, 2);
		String idValue = entries[0].trim();
		if (idValue.length() > 0)
			result.id = Long.parseLong(idValue);

		return result;
	}
}
