package com.tandbergtv.neptune.widgettoolkit.client.util;

import com.google.gwt.i18n.client.NumberFormat;

public class FormatUtil {

    private static final String[] UNITS = new String[] { "B", "KB", "MB", "GB", "TB" };

    /**Format the numeric bytes to string with units, for example 1024 will be 1K.
     * @param bytes
     * @return
     */
    public static String formatBytes(long bytes) {
        if (bytes <= 0) {
            return "0";
        }
        int digitGroups = (int) (Math.log10(bytes) / Math.log10(1024));
        return NumberFormat.getFormat("#,##0.#").format(bytes / Math.pow(1024, digitGroups)) + " " + UNITS[digitGroups];
    }
}
