/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.event;

import com.google.gwt.event.shared.GwtEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Record click event indicating the user has clicked on a table record
 * 
 * @author Vijay Silva
 */
public class RecordClickEvent<R extends Record<?>> extends GwtEvent<RecordClickHandler<R>> {

	/* The handler type */
	private static Type<RecordClickHandler<?>> TYPE;
	private R record;

	/**
	 * Constructor
	 * 
	 * @param record The record
	 */
	public RecordClickEvent(R record) {
		this.record = record;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<RecordClickHandler<?>> getType() {
		if (TYPE == null) {
			TYPE = new Type<RecordClickHandler<?>>();
		}

		return TYPE;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public Type<RecordClickHandler<R>> getAssociatedType() {
		return (Type) TYPE;
	}

	/*
	 * Fire the event
	 */
	@Override
	protected void dispatch(RecordClickHandler<R> handler) {
		handler.onRecordClick(this);
	}

	/**
	 * Get the clicked record
	 * 
	 * @return The record
	 */
	public R getRecord() {
		return this.record;
	}
}
