/*
 * Created on Sep 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor;

/**
 * Change event indicating that the table anchor has been updated as a result of an action on the
 * table
 * 
 * @author Vijay Silva
 */
public class TableAnchorChangeEvent {

	/* The new table anchor */
	private final TableAnchor anchor;

	/**
	 * Constructor
	 * 
	 * @param anchor The table anchor
	 */
	public TableAnchorChangeEvent(TableAnchor anchor) {
		this.anchor = anchor;
	}

	/**
	 * @return the anchor
	 */
	public TableAnchor getAnchor() {
		return anchor;
	}
}
