package com.tandbergtv.neptune.widgettoolkit.client.menu;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

public class MappingMenuItem extends URLMenuItem implements IsSerializable {

    private String baseUrl;

    private String defaultMapping;

    private Map<String, String> pathMapping = new HashMap<String, String>();

    public MappingMenuItem() {
        //
    }

    public MappingMenuItem(String name, String displayName, String baseUrl, String defaultMapping,
            Map<String, String> pathMapping) {
        super(name, displayName, baseUrl
                + ((baseUrl == null) || baseUrl.endsWith("/") ? defaultMapping : "/" + defaultMapping));
        this.baseUrl = baseUrl;
        this.defaultMapping = defaultMapping;
        this.pathMapping = pathMapping;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getDefaultMapping() {
        return defaultMapping;
    }

    public void setDefaultMapping(String defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    public Map<String, String> getPathMapping() {
        return pathMapping;
    }

    public void setPathMapping(Map<String, String> pathMapping) {
        this.pathMapping = pathMapping;
    }
}
