/*
 * Created on May 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ToggleButton;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link ToggleButton} widget.
 * 
 * @see com.google.gwt.user.client.ui.ToggleButton
 * @author Vijay Silva
 */
public class ToggleButtonWidget extends ToggleButton implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ToggleButton#ToggleButton()
	 */
	public ToggleButtonWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ToggleButton#ToggleButton(String)
	 */
	public ToggleButtonWidget(String upText) {
		super(upText);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ToggleButton#ToggleButton(String, String)
	 */
	public ToggleButtonWidget(String upText, String downText) {
		super(upText, downText);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ToggleButton#ToggleButton(Image)
	 */
	public ToggleButtonWidget(Image upImage) {
		super(upImage);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ToggleButton#ToggleButton(Image, Image)
	 */
	public ToggleButtonWidget(Image upImage, Image downImage) {
		super(upImage, downImage);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ToggleButton#ToggleButton(String, ClickHandler)
	 */
	public ToggleButtonWidget(String upText, ClickHandler handler) {
		super(upText, handler);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ToggleButton#ToggleButton(Image, ClickHandler)
	 */
	public ToggleButtonWidget(Image upImage, ClickHandler handler) {
		super(upImage, handler);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.ToggleButton#ToggleButton(Image, Image, ClickHandler)
	 */
	public ToggleButtonWidget(Image upImage, Image downImage, ClickHandler handler) {
		super(upImage, downImage, handler);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}
}
