/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.component.services;

import com.ericsson.neptune.component.entity.IMenuItem;
import com.ericsson.neptune.component.entity.IPortlet;
import com.ericsson.neptune.component.services.IComponentRegistrationDataServer;
import com.ericsson.neptune.distributed.component.jaxb.AuthorizationDataListType;
import com.ericsson.neptune.distributed.component.jaxb.AuthorizationDataType;
import com.ericsson.neptune.distributed.component.jaxb.ComponentType;
import com.ericsson.neptune.distributed.component.jaxb.GroupMenuItemType;
import com.ericsson.neptune.distributed.component.jaxb.LocationListType;
import com.ericsson.neptune.distributed.component.jaxb.LocationType;
import com.ericsson.neptune.distributed.component.jaxb.MenuItemListType;
import com.ericsson.neptune.distributed.component.jaxb.MenuItemType;
import com.ericsson.neptune.distributed.component.jaxb.ModuleListType;
import com.ericsson.neptune.distributed.component.jaxb.ModuleType;
import com.ericsson.neptune.distributed.component.jaxb.NamedLocationType;
import com.ericsson.neptune.distributed.component.jaxb.PermissionListType;
import com.ericsson.neptune.distributed.component.jaxb.PermissionType;
import com.ericsson.neptune.distributed.component.jaxb.PortletListType;
import com.ericsson.neptune.distributed.component.jaxb.PortletType;
import com.ericsson.neptune.distributed.component.jaxb.URLMenuItemType;
import com.ericsson.neptune.distributed.component.jaxb.URLType;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.entity.IPermission;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

public class ComponentRegistrationDataServer
implements IComponentRegistrationDataServer {
    @Context
    UriInfo uriInfo;
    private static final Logger logger = Logger.getLogger(ComponentRegistrationDataServer.class);
    private static final String APP_CONTEXT = "/cms";
    private static final String SERVICES_CONTEXT = "/components";
    protected ComponentType component = new ComponentType();

    public ComponentRegistrationDataServer() {
        LocationListType locationList = new LocationListType();
        this.component.setLocations(locationList);
        MenuItemListType mainMenuList = new MenuItemListType();
        this.component.setMenuItems(mainMenuList);
        PortletListType portletList = new PortletListType();
        this.component.setPortlets(portletList);
        ModuleListType moduleList = new ModuleListType();
        this.component.setModules(moduleList);
    }

    @Override
    public Response getRegistrationData(String authorizationHeader, String componentName) {
        this.component.setName(componentName);
        this.component.setDisplayName(componentName);
        String baseUrl = this.uriInfo.getBaseUri().toString();
        String appUrl = baseUrl.substring(0, baseUrl.indexOf(SERVICES_CONTEXT)) + APP_CONTEXT;
        this.setDefaultLocation(appUrl);
        Response.ResponseBuilder builder = Response.ok((Object)this.component);
        return builder.build();
    }

    public void setDefaultLocation(String url) {
        LocationType defaultLocation = new LocationType();
        defaultLocation.setValue(url);
        this.component.getLocations().setDefaultLocation(defaultLocation);
    }

    public void setLocation(String name, String url) {
        NamedLocationType locationType = new NamedLocationType();
        locationType.setName(name);
        locationType.setValue(url);
        this.component.getLocations().getLocation().add(locationType);
    }

    public void addModule(IModule module) {
        ModuleType moduleType = new ModuleType();
        moduleType.setName(module.getName());
        moduleType.setDisplayName(module.getDisplayName());
        PermissionListType permissionList = new PermissionListType();
        for (IPermission permission : module.getPermissions()) {
            PermissionType permissionType = new PermissionType();
            permissionType.setName(permission.getName());
            permissionType.setDisplayName(permission.getDisplayName());
            permissionList.getPermission().add(permissionType);
        }
        moduleType.setPermissions(permissionList);
        this.component.getModules().getModule().add(moduleType);
    }

    public void addPortlets(List<IPortlet> portlets) {
        for (IPortlet portlet : portlets) {
            PortletType next = new PortletType();
            next.setName(portlet.getId());
            next.setDisplayName(portlet.getDisplayName());
            next.setAuthorization(this.getAuthorizationDataListType(portlet.getRoles()));
            URLType urlType = new URLType();
            urlType.setLocationName(portlet.getURLLocationName());
            urlType.setPath(portlet.getURL());
            next.setUrl(urlType);
            this.component.getPortlets().getPortlet().add(next);
        }
    }

    public void setMenus(List<IMenuItem> menus) {
        for (IMenuItem menuItem : menus) {
            this.component.getMenuItems().getMenuGroupOrMenuItem().add(this.createMenuItem(menuItem));
        }
    }

    private MenuItemType createMenuItem(IMenuItem menuItem) {
        GroupMenuItemType menuItemType;
        if (menuItem.isLeaf()) {
            URLMenuItemType urlMenuItem = new URLMenuItemType();
            urlMenuItem.setName(menuItem.getName());
            urlMenuItem.setDisplayName(menuItem.getDisplayName());
            URLType urlType = new URLType();
            urlType.setLocationName(menuItem.getURLLocationName());
            urlType.setPath(menuItem.getURL());
            urlMenuItem.setUrl(urlType);
            urlMenuItem.setAuthorization(this.getAuthorizationDataListType(menuItem.getRoles()));
            menuItemType = urlMenuItem;
        } else {
            GroupMenuItemType subGroup = new GroupMenuItemType();
            subGroup.setName(menuItem.getName());
            subGroup.setDisplayName(menuItem.getDisplayName());
            subGroup.setChildren(new MenuItemListType());
            subGroup.setMergeRequired(Boolean.valueOf(menuItem.isMergeRequired()));
            for (IMenuItem child : menuItem.getChildren()) {
                subGroup.getChildren().getMenuGroupOrMenuItem().add(this.createMenuItem(child));
            }
            menuItemType = subGroup;
        }
        return menuItemType;
    }

    private AuthorizationDataListType getAuthorizationDataListType(HashSet<String> roles) {
        AuthorizationDataListType authList = new AuthorizationDataListType();
        if (roles == null) {
            return authList;
        }
        for (String role : roles) {
            AuthorizationDataType auth = new AuthorizationDataType();
            int index = role.indexOf("_");
            if (index < 1 || index > role.length() - 2) {
                logger.error((Object)("Invalid role format " + role));
                continue;
            }
            auth.setModuleName(role.substring(0, index));
            auth.setPermissionName(role.substring(index + 1));
            authList.getPermission().add(auth);
        }
        return authList;
    }
}

