package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Style.Overflow;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.tandbergtv.neptune.widgettoolkit.client.util.StringUtils;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;

/**
 * 
 * A small pop up window for prompting message. toast window will auto close after a specified delay time.
 * @author Evan Huang
 */
public class ToastWindow {

	private static final int WIDTH = 250;
	private static final int HEIGHT = 100;
	private static final int INTERVAL = 20;

	private int endPosition = 20;
	private int delayToClose;

	private CleanStylePopupPanel mainScreen = new CleanStylePopupPanel();
	private Timer closeSlideDownTimer;
	private Timer closeTriggerTimer;

	public ToastWindow() {
		//
	}

	public void setDelayToClose(int delayToClose) {
		this.delayToClose = delayToClose;
	}

	public void buildToast(String message, final int delayToClose, String colorStyle, String closeBtnStyle) {
		this.delayToClose = delayToClose;
		createToastBody(colorStyle, closeBtnStyle, message);
		setPosition();
	}

	/**
	 * set the default show position on the bottom.
	 */
	public void setPosition() {
		mainScreen.setPopupPosition((Window.getClientWidth() - WIDTH) / 2,
				Window.getClientHeight() - HEIGHT - INTERVAL);
	}

	/**
	 * set the default show position in the middle.
	 */
	public void setPositionInMiddle() {
		int top = (Window.getClientHeight() - HEIGHT) / 2 + 20;
		mainScreen.setPopupPosition((Window.getClientWidth() - WIDTH) / 2, top);
		endPosition = top + INTERVAL * 4;
	}

	/**
	 * show the toast
	 */
	public void show() {
		mainScreen.show();

		if (delayToClose <= 0) {
			return;
		}

		closeTriggerTimer = new Timer() {
			@Override
			public void run() {
				slideDown();
			}
		};
		closeTriggerTimer.schedule(delayToClose);
	}

	protected void createToastBody(String colorStyleName, String closeBtnStyle, String msg) {
		SimplePanel mainBar = new SimplePanel();
		mainBar.setStyleName("ebNotification");
		mainBar.addStyleName(colorStyleName);

		FlowPanel outer = new FlowPanel();
		outer.addStyleName("ebNotification-content");

		SimplePanel messageSp = new SimplePanel();
		messageSp.getElement().setInnerText(msg);
		messageSp.setStyleName("ebNotification-label");

		outer.add(messageSp);

		SimplePanel closeBtnSp = new SimplePanel();
		closeBtnSp.setStyleName("ebNotification-close");

		ButtonWidget closeBtn = creatCloseButton("", createCloseHandler());
		closeBtn.addStyleName("ebIcon");
		closeBtn.addStyleName(closeBtnStyle);
		closeBtn.addStyleName("ebIcon_interactive");

		closeBtnSp.add(closeBtn);
		outer.add(closeBtnSp);

		mainBar.setWidget(outer);

		mainScreen.setWidget(mainBar);
		mainScreen.removeStyleName("gwt-PopupPanel");
		mainBar.getParent().removeStyleName("popupContent");
	}

	private ClickHandler createCloseHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				close();
			}
		};
	}

	private void slideDown() {
		mainScreen.getElement().getStyle().setOverflow(Overflow.HIDDEN);

		closeSlideDownTimer = new Timer() {
			@Override
			public void run() {
				int offsetLeft = mainScreen.getElement().getOffsetLeft();
				int clientHeight = mainScreen.getElement().getClientHeight();
				if (clientHeight <= endPosition) {
					close();
					return;
				}
				mainScreen.getElement().getStyle().setHeight(clientHeight - INTERVAL, Unit.PX); // NOSONAR
				mainScreen.setPopupPosition(offsetLeft, (mainScreen.getPopupTop() + INTERVAL) - 6);
			}

		};
		closeSlideDownTimer.scheduleRepeating(100);
	}

	/**
	 * close current toastWindow
	 */
	public void close() {
		mainScreen.hide();
		
		if (closeSlideDownTimer != null) {
			closeSlideDownTimer.cancel();
			closeSlideDownTimer = null;
		}
		
		if (closeTriggerTimer != null) {
			closeTriggerTimer.cancel();
			closeTriggerTimer = null;
		}
	}

	private ButtonWidget creatCloseButton(String tips, ClickHandler clickHandler) {
		ButtonWidget button = new ButtonWidget();
		button.setTitle(StringUtils.trim(tips));

		if (clickHandler != null) {
			button.addClickHandler(clickHandler);
		}
		return button;
	}

	/**
	 * clean the gwt style to get E/// visualize style.
	 */
	class CleanStylePopupPanel extends PopupPanel {
		CleanStylePopupPanel() {
			removeStyleName("gwt-PopupPanel");
			getContainerElement().removeClassName("popupContent");
		}
	}
}
