/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.licensing;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.licensing.EncryptionUtil;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import javax.ejb.Local;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Local(value={ILicenseManager.class})
@Stateless
public class LicenseManager
implements ILicenseManager {
    private static final String NEPTUNE_DIR = "neptune";
    private static final String ENCRYPTED_FILE_NAME = "licensekey.lic";
    private static final String PASSWORD = "TandbergTelevisionPartOfTheEricssonGroup";
    private static final Logger logger = Logger.getLogger(LicenseManager.class);

    public Properties getProperties() throws InvalidLicenseException {
        IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File file = configReaderService.getFile(NEPTUNE_DIR, ENCRYPTED_FILE_NAME);
        return this.getPropertiesInternal(file);
    }

    protected Properties getPropertiesInternal(File file) throws InvalidLicenseException {
        if (!file.exists()) {
            logger.error((Object)("[Configuration Error] licensekey.lic " + file.getAbsolutePath() + " license file not found"));
            throw new InvalidLicenseException("License file not found");
        }
        String encrLicenseFilePath = file.getAbsolutePath();
        EncryptionUtil encUtil = new EncryptionUtil();
        InputStream cis = encUtil.getEncryptedInputStream(PASSWORD, encrLicenseFilePath);
        Properties prop = new Properties();
        try {
            prop.loadFromXML(cis);
        }
        catch (Exception e) {
            throw new InvalidLicenseException("Could not read properties from the encrypted input stream", (Throwable)e);
        }
        return prop;
    }

    public Properties getProperties(File parentFolder) throws InvalidLicenseException {
        File neptuneDir = new File(parentFolder, NEPTUNE_DIR);
        File licenseFile = new File(neptuneDir, ENCRYPTED_FILE_NAME);
        return this.getPropertiesInternal(licenseFile);
    }

    public String getProperty(String key) throws InvalidLicenseException {
        return this.getProperties().getProperty(key);
    }
}

