/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.ericsson.neptune.alerts.ejb.Aggregator;
import com.ericsson.neptune.alerts.ejb.JobScheduler;
import com.ericsson.neptune.alerts.entity.Alert;
import com.ericsson.neptune.alerts.entity.AlertsSummary;
import com.ericsson.neptune.alerts.entity.SeverityType;
import com.tandbergtv.neptune.actionItems.cache.ICacheService;
import com.tandbergtv.neptune.actionItems.cache.ServiceRegistry;
import com.tandbergtv.neptune.alerts.service.IAlertsAggregationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Singleton;
import org.apache.log4j.Logger;

@Singleton(name="Neptune:service=com.tandbergtv.neptune.alerts.service.IAlertAggregationService")
@Local(value={IAlertsAggregationService.class})
@DependsOn(value={"Neptune:service=com.tandbergtv.neptune.clustermgmt.service.IClusterConfigurationService"})
public class AlertsAggregationService
implements IAlertsAggregationService {
    private static final String ALERTS_CACHE_KEY = "cachekey";
    private static final Logger logger = Logger.getLogger(AlertsAggregationService.class);
    private static final String ALERT_TIME_INTERVAL = "com.ericsson.cms.neptune.uialerts.timeinterval";
    private static final int ALERT_MAX_THREADS = 4;
    int waitTime = 0;
    int pollInterval = 0;
    int readTimeout = 10000;
    int alertsCacheSize = 4096;
    @EJB
    private ISettingsService settingsService;

    @PostConstruct
    public void start() throws Exception {
        try {
            this.pollInterval = Integer.parseInt((String)this.settingsService.getProperties(ALERT_TIME_INTERVAL).get("poll_interval"));
            this.waitTime = Integer.parseInt((String)this.settingsService.getProperties(ALERT_TIME_INTERVAL).get("wait_time"));
            this.readTimeout = Integer.parseInt((String)this.settingsService.getProperties(ALERT_TIME_INTERVAL).get("read_timeout"));
            this.alertsCacheSize = Integer.parseInt((String)this.settingsService.getProperties(ALERT_TIME_INTERVAL).get("alerts_cache_size"));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"Unable to parse Aggregator poll_Interval, waitTime, or read_timeout setting.", (Throwable)e);
        }
        if (this.pollInterval == 0) {
            return;
        }
        JobScheduler scheduler = new JobScheduler(1);
        scheduler.getExecutor().setMaximumPoolSize(4);
        scheduler.schedule(new Aggregator(this.readTimeout, this.alertsCacheSize), this.waitTime, this.pollInterval);
        logger.info((Object)("Alert aggregation job scheduled every " + this.pollInterval / 1000 + " secs"));
    }

    private void populateCache(List<Alert> alertList) {
        this.getCache().add((Serializable)((Object)ALERTS_CACHE_KEY), alertList);
    }

    private void emptyCache() {
        this.getCache().remove((Serializable)((Object)ALERTS_CACHE_KEY));
    }

    private ICacheService<List<Alert>> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("alertsCache");
    }

    public synchronized AlertsSummary getSummary() {
        long lStartTime = System.nanoTime();
        AlertsSummary sum = new AlertsSummary();
        int errors = 0;
        int warnings = 0;
        int informationals = 0;
        List<Alert> alerts = this.getCache().get((Serializable)((Object)ALERTS_CACHE_KEY));
        if (alerts != null && !alerts.isEmpty()) {
            for (Alert alert : alerts) {
                if (alert.getSeverity() == SeverityType.Error) {
                    ++errors;
                    continue;
                }
                if (alert.getSeverity() == SeverityType.Warning) {
                    ++warnings;
                    continue;
                }
                if (alert.getSeverity() != SeverityType.Informational) continue;
                ++informationals;
            }
        }
        sum.setTotalErrors(Integer.valueOf(errors));
        sum.setTotalWarnings(Integer.valueOf(warnings));
        sum.setTotalInformationals(Integer.valueOf(informationals));
        long lEndTime = System.nanoTime();
        long difference = lEndTime - lStartTime;
        logger.debug((Object)("Elapsed milliseconds in getSummary : " + difference / 1000000L));
        return sum;
    }

    public synchronized List<Alert> getAlerts() {
        long lStartTime = System.nanoTime();
        ArrayList<Alert> alertsList = new ArrayList<Alert>();
        List<Alert> alerts = this.getCache().get((Serializable)((Object)ALERTS_CACHE_KEY));
        if (alerts != null && !alerts.isEmpty()) {
            alertsList.addAll(alerts);
        }
        long lEndTime = System.nanoTime();
        long difference = lEndTime - lStartTime;
        logger.debug((Object)("Elapsed milliseconds in getAlerts : " + difference / 1000000L));
        return alertsList;
    }

    public synchronized void setAlerts(List<Alert> alerts) {
        long lStartTime = System.nanoTime();
        this.emptyCache();
        if (alerts != null && !alerts.isEmpty()) {
            this.populateCache(alerts);
        }
        long lEndTime = System.nanoTime();
        long difference = lEndTime - lStartTime;
        logger.debug((Object)("Elapsed milliseconds in setAlerts : " + difference / 1000000L));
    }
}

