/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.conf;

import com.tandbergtv.neptune.realm.conf.IRealmConfigurationService;
import com.tandbergtv.neptune.realm.conf.RealmConfigurationException;
import com.tandbergtv.neptune.realm.conf.RealmConfigurationReader;
import com.tandbergtv.neptune.realm.persist.RoleKey;
import com.tandbergtv.neptune.usermgmt.external.UserConfigurationFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.ejb.DependsOn;
import javax.ejb.Singleton;
import org.apache.log4j.Logger;

@DependsOn(value={"Neptune:service=com.tandbergtv.neptune.configuration.service.IConfigurationService"})
@Singleton(name="Neptune:service=com.tandbergtv.neptune.realm.conf.IRealmConfigurationService")
public class RealmConfigurationService
implements IRealmConfigurationService {
    private static final Logger logger = Logger.getLogger(RealmConfigurationService.class);
    private RealmConfigurationReader configurationReader = new RealmConfigurationReader();
    private Properties configuration = null;
    private String filePath;
    private static final String PROPS = "./neptune_realm.properties";

    @Override
    @PostConstruct
    public void start() throws Exception {
        try {
            this.configuration = this.configurationReader.readRealmConfiguration(PROPS);
        }
        catch (Exception e) {
            String msg = "[Configuration Error] ./neptune_realm.properties is missing, error: " + e.getLocalizedMessage();
            throw new RealmConfigurationException(msg, e);
        }
        try {
            UserConfigurationFactory.getFactory();
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            UserConfigurationFactory.getInternalModeFactory();
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public Properties getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getAdministratorUserName() throws RealmConfigurationException {
        String userName = this.configuration.getProperty("NeptuneRealm.AdministratorUserName");
        return userName != null ? userName.trim() : null;
    }

    @Override
    public List<RoleKey> getAdministratorRoleKeys() throws RealmConfigurationException {
        ArrayList<RoleKey> roleKeys = new ArrayList<RoleKey>();
        String key = "NeptuneRealm.AdministratorRoleIDs";
        String value = this.configuration.getProperty(key);
        List<String> allValues = this.getValues(value, ",");
        for (String roleKeyValue : allValues) {
            RoleKey roleKey = new RoleKey();
            try {
                Long roleId = new Long(roleKeyValue);
                roleKey.setId(roleId);
            }
            catch (Exception e) {
                String msg = "[Configuration Error] " + key + " " + this.filePath + " failed to parse the list of administrator role IDs, " + "value: " + roleKeyValue + " is not a valid role ID.";
                throw new RealmConfigurationException(msg, e);
            }
            roleKeys.add(roleKey);
        }
        return roleKeys;
    }

    private List<String> getValues(String valueList, String separator) {
        String[] values;
        ArrayList<String> allValues = new ArrayList<String>();
        if (valueList != null && (values = valueList.split(separator)) != null) {
            for (String value : values) {
                if (value == null || (value = value.trim()).length() <= 0) continue;
                allValues.add(value);
            }
        }
        return allValues;
    }
}

