/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.authorization.ejb;

import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.entity.IPermission;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.authorization.service.internal.IEJB3RoleGenerator;
import com.tandbergtv.neptune.realm.persist.Module;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.util.SecurityInfo;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.jboss.ejb3.annotation.SecurityDomain;

@Stateless
@SecurityDomain(value="cms")
public class AuthorizationService
implements IAuthorizationService {
    @PersistenceContext(unitName="NeptuneRealm")
    protected EntityManager entityManager;
    @EJB
    protected IEJB3RoleGenerator roleGenerator;
    @Resource
    protected SessionContext sessionContext;

    public String getUserName() {
        Principal principal = this.getCallerPrincipal();
        return principal != null ? principal.getName() : null;
    }

    public boolean isAuthorized(String role) {
        if (role == null) {
            return false;
        }
        return this.sessionContext.isCallerInRole(role);
    }

    public boolean isAuthorized(String moduleName, String permissionName) {
        String role = this.roleGenerator.generateRole(moduleName, permissionName);
        return this.isAuthorized(role);
    }

    public boolean isAuthorized(IPermission permission) {
        String role = this.roleGenerator.generateRole(permission);
        return this.isAuthorized(role);
    }

    @TransactionAttribute
    public Set<String> getAuthorizedRoles() {
        HashSet<String> roles = new HashSet<String>();
        List<Module> persistedModules = this.getAllModules();
        for (Module persistedModule : persistedModules) {
            for (Permission persistedPermission : persistedModule.getPermissions()) {
                String permissionName;
                String moduleName = persistedPermission.getModule().getName();
                String role = this.roleGenerator.generateRole(moduleName, permissionName = persistedPermission.getName());
                if (!this.isAuthorized(role)) continue;
                roles.add(role);
            }
        }
        return roles;
    }

    @TransactionAttribute
    public Set<IPermission> getAuthorizedPermissions() {
        HashSet<IPermission> permissions = new HashSet<IPermission>();
        List<Module> persistedModules = this.getAllModules();
        for (Module persistedModule : persistedModules) {
            this.addAuthorizedPermissions(persistedModule.getPermissions(), permissions);
        }
        return permissions;
    }

    @TransactionAttribute
    public Set<IModule> getAuthorizedPermissionsByModule() {
        HashSet<IModule> modules = new HashSet<IModule>();
        List<Module> persistedModules = this.getAllModules();
        for (Module persistedModule : persistedModules) {
            ArrayList<IPermission> authorizedPermissions = new ArrayList<IPermission>();
            this.addAuthorizedPermissions(persistedModule.getPermissions(), authorizedPermissions);
            if (authorizedPermissions.size() <= 0) continue;
            IModule module = this.buildModule(persistedModule, authorizedPermissions);
            modules.add(module);
        }
        return modules;
    }

    @TransactionAttribute
    public IModule getAuthorizedPermissionsByModule(String moduleName) {
        IModule module = null;
        Module persistedModule = this.getModule(moduleName);
        if (persistedModule == null) {
            return null;
        }
        ArrayList<IPermission> authorizedPermissions = new ArrayList<IPermission>();
        this.addAuthorizedPermissions(persistedModule.getPermissions(), authorizedPermissions);
        if (authorizedPermissions.size() > 0) {
            module = this.buildModule(persistedModule, authorizedPermissions);
        }
        return module;
    }

    private void addAuthorizedPermissions(Collection<Permission> permissions, Collection<IPermission> authorizedPermissions) {
        for (Permission permission : permissions) {
            String permissionName;
            String moduleName = permission.getModule().getName();
            if (!this.isAuthorized(moduleName, permissionName = permission.getName())) continue;
            IPermission authorizedPermission = this.buildPermission(permission);
            authorizedPermissions.add(authorizedPermission);
        }
    }

    private IModule buildModule(Module persistedModule, List<IPermission> authorizedPermissions) {
        BasicModule module = new BasicModule();
        module.setName(persistedModule.getName());
        module.setDisplayName(persistedModule.getDisplayName());
        module.setPermissions(authorizedPermissions);
        return module;
    }

    private IPermission buildPermission(Permission persistedPermission) {
        BasicPermission permission = new BasicPermission();
        permission.setName(persistedPermission.getName());
        permission.setDisplayName(persistedPermission.getDisplayName());
        permission.setModuleName(persistedPermission.getModule().getName());
        return permission;
    }

    private List<Module> getAllModules() {
        Query query = this.entityManager.createNamedQuery("Module.FindAll");
        return query.getResultList();
    }

    private Module getModule(String moduleName) {
        Module result = null;
        if (moduleName == null) {
            return result;
        }
        Query query = this.entityManager.createNamedQuery("Module.FindByName");
        query.setParameter("name", (Object)moduleName);
        try {
            result = (Module)query.getSingleResult();
        }
        catch (NoResultException nre) {
            result = null;
        }
        return result;
    }

    private Principal getCallerPrincipal() {
        return SecurityInfo.getCallerPrincipal();
    }
}

