/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.settings.cache;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MessageListener;
import com.tandbergtv.neptune.settings.cache.SettingsCache;
import com.tandbergtv.neptune.settings.cache.SettingsChangeHazelcastMessage;
import org.apache.log4j.Logger;

public class SettingsMessageListener
implements MessageListener<SettingsChangeHazelcastMessage> {
    private static final Logger logger = Logger.getLogger(SettingsMessageListener.class);

    public void onMessage(SettingsChangeHazelcastMessage msg) {
        try {
            if (msg.getGroupPath() == null || msg.getGroupPath().length() == 0 || msg.getSender() == null) {
                return;
            }
            logger.debug((Object)("SettingsChangeHazelcastMessage received - Msg:" + msg.getGroupPath() + ":" + msg.getSender().getHostName()));
            if (Hazelcast.getCluster().getLocalMember().getInetSocketAddress().equals(msg.getSender())) {
                return;
            }
            SettingsCache.getInstance().updateGroup(msg.getGroupPath());
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to update local cache", t);
        }
    }
}

