package com.tandbergtv.neptune.ui.portalpage.client.ui;

import org.gwtportlets.portlet.client.WidgetFactory;
import org.gwtportlets.portlet.client.WidgetInfo;
import org.gwtportlets.portlet.client.layout.Container;
import org.gwtportlets.portlet.client.layout.ContainerFactory;
import org.gwtportlets.portlet.client.layout.LDOM;
import org.gwtportlets.portlet.client.layout.RowLayout;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.client.Element;
import com.tandbergtv.neptune.ui.portalpage.client.HtmlPortletConfig;

/**
 * Gadget with a PortletFrame
 */
@SuppressWarnings("unchecked")
public class HtmlGadget extends Gadget {

    private PortletFrame portlet = new PortletFrame();
    private int portletHeight = 0;
    private HtmlPortletConfig config;

    public HtmlGadget() {
        this("","","","");
    }

    public HtmlGadget(HtmlPortletConfig config) {
        this(config.getComponent(), config.getPortletId(), config.getTitle(), config.getUrl());
        this.config = config;
        setDefaultHeight(config);
    }

    public HtmlGadget(String component, String portletId, String title, String url) {
        super();
        super.setPortletId(portletId);
        super.setPortletTitle(title);
        portlet.setComponent(component);
        super.add(portlet);
        setUrl(url);
    }

    @Override
    public void restore() {
        super.restore();
        if (portlet.getLastHeight() <= 0) {
            setHeight(portletHeight);
        }
    }

    @Override
    public void minimize() {
        int displayedPortletHeight = portlet.getLastHeight();
        if (displayedPortletHeight > 0) {
            portletHeight = displayedPortletHeight;
        }
        super.minimize();
    }

    @Override
    public String getComponent() {
        return portlet.getComponent();
    }

    public void setComponent(String component) {
        portlet.setComponent(component);
    }

    public String getUrl() {
        return portlet.getUrl();
    }

    public void setUrl(String url) {
        portlet.setUrl(url);
    }

    public boolean matchesUrl(String url) {
        String formatUrl = portlet.formatUrl(url);
        String portletUrl = portlet.getUrl();
        if (formatUrl.startsWith("/")) {
            return portletUrl.endsWith(formatUrl);
        } else if (portletUrl.startsWith("/")) {
            return formatUrl.endsWith(portletUrl);
        }
        return portletUrl.equals(formatUrl);
    }

    private void setDefaultHeight(HtmlPortletConfig config) {
        if ((config == null) || (config.getStyles() == null)) {
            return;
        }
        try {
            defaultHeight = Integer.parseInt(config.getStyles().get("height"));
        } catch (Exception e) {
            GWT.log("cannot retrive customized portlet height", e);
            // do nothing
        }
    }

    @Override
    public void setHeight(int height) {
        if (isMinimized) {
            portletHeight = height;
            return;
        }

        int lastHeight = portlet.getLastHeight();
        if ((height >= 0) && (height != lastHeight)) {
            int totalHeight = height + TITLE_HEIGHT;
            Container container = (Container) getParent();
            if (container != null) {
                Element ce = container.getElement();
                int containerSize = LDOM.getContentHeight(ce);
                RowLayout.Constraints c =
                        (RowLayout.Constraints)container.getLayoutConstraints(this);
                int maxSize = c.getMaxSize();
                if ((maxSize > 0) && (totalHeight > maxSize)) {
                    // change the max size
                    c.setMaxSize(totalHeight);
                } else {
                    if (c.getSize() < 1.0f) { // set new proportional size
                        float f = (float)totalHeight / containerSize;
                        c.setSize(f > 0.999f ? 0.999f : f);
                    } else { // set new pixel size
                        c.setSize(totalHeight);
                    }
                }
                container.layout();
            }
            portlet.setHeight(height);
        }
    }

    /**
     * Get the portlet config of this HTML gadget.
     *
     * @return
     */
    public HtmlPortletConfig getConfig() {
        return config;
    }

    @Override
    public WidgetFactory<HtmlGadget> createWidgetFactory() {
        return new Factory(this);
    }

    @WidgetInfo(description = "Gadget displaying PortletFrame in TitlePanel")
    public static class Factory extends ContainerFactory<HtmlGadget> {

        private static final long serialVersionUID = 1L;
        private String component;
        private String portletId;
        public String url;
        private String title;

        public Factory() {
        }

        public Factory(HtmlGadget gadget) {
            super(gadget);
            component = gadget.getComponent();
            portletId = gadget.getPortletId();
            url = gadget.getUrl();
            title = gadget.getTitleText();
        }

        @Override
        public void refresh(HtmlGadget gadget) {
            super.refresh(gadget);
            gadget.setComponent(component);
            gadget.setPortletId(portletId);
            gadget.setUrl(url);
            gadget.setPortletTitle(title);
        }

        @Override
        public HtmlGadget createWidget() {
            return new HtmlGadget();
        }
    }

}
