/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.util;

import com.ericsson.neptune.security.util.HttpConnUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Objects;
import org.apache.log4j.Logger;

public class RestHelper {
    private static final Logger LOG = Logger.getLogger(RestHelper.class);
    private static final String EMPTY_RESPONSE = "";

    public String sendRest(String httpUrl, String accessToken) {
        String bearerAuth = String.format("Bearer %s", accessToken);
        return this.makeGetRequest(httpUrl, bearerAuth);
    }

    public String makeGetRequest(String requestUri, String authorizationHeader) {
        String response = EMPTY_RESPONSE;
        HttpURLConnection conn = null;
        try {
            conn = HttpConnUtil.openHttpConnection(requestUri);
            Objects.requireNonNull(conn, "Cannot establish http connection with " + requestUri);
            conn.setRequestMethod("GET");
            if (authorizationHeader != null) {
                conn.setRequestProperty("Authorization", authorizationHeader);
            }
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            response = this.getResponseBody(conn);
            if (conn.getResponseCode() >= 400) {
                LOG.warn((Object)("Failed to make POST request with " + requestUri + ", error: " + response));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
            LOG.debug((Object)e);
        }
        return response;
    }

    public String makePostRequest(String requestUri, String authorizationHeader) {
        String response = EMPTY_RESPONSE;
        HttpURLConnection conn = null;
        try {
            conn = HttpConnUtil.openHttpConnection(requestUri);
            Objects.requireNonNull(conn, "Cannot establish http connection with " + requestUri);
            conn.setRequestMethod("POST");
            if (authorizationHeader != null) {
                conn.setRequestProperty("Authorization", authorizationHeader);
            }
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            response = this.getResponseBody(conn);
            if (conn.getResponseCode() >= 400) {
                LOG.warn((Object)("Failed to make GET request with " + requestUri + ", error: " + response));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
            LOG.debug((Object)e);
        }
        return response;
    }

    private String getResponseBody(HttpURLConnection conn) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = this.getBufferReader(conn);){
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
            LOG.debug((Object)e);
        }
        return sb.toString();
    }

    private BufferedReader getBufferReader(HttpURLConnection conn) throws IOException {
        try {
            return new BufferedReader(new InputStreamReader(conn.getInputStream()));
        }
        catch (Exception e) {
            return new BufferedReader(new InputStreamReader(conn.getErrorStream()));
        }
    }
}

