/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import com.ericsson.neptune.security.authprovider.TokenInfo;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import com.ericsson.neptune.security.filter.helper.CookieCacheManager;
import com.ericsson.neptune.security.util.EncodingUtils;
import com.ericsson.neptune.security.util.HttpURLUtil;
import com.ericsson.neptune.security.util.OAuth2Util;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;

public class OAuthAuthenticationFilter
extends BaseSecurityFilter {
    public static final String SESSION_COMPONENT_NAME = "COMPONENT_NAME";
    public static final String DEFAULT_NEPTUNE_COMPONENT_NAME = "DEFAULT_NEPTUNE";
    protected static final String NEPTUNE_SSO_OAUTH2_CLIENT_ID = "neptune_sso_oauth2_client_id";
    protected static final String NEPTUNE_SSO_OAUTH2_CLIENT_SECRET = "neptune_sso_oauth2_client_secret";
    protected static final String NEPTUNE_SSO_OAUTH2_RESPONSE_TYPE = "neptune_sso_oauth2_response_type";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_TOKEN_TYPE = "token_type";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_USERNAME = "username";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_EXPIRES_IN = "expires_in";
    private static final String NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_BOOKMARK = "bookmark";
    private static final List<String> NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS = new ArrayList<String>();
    private static final String OAUTH2_ACCESS_TOKEN = "access_token";
    private static final String OAUTH2_CLIENT_ID = "client_id";
    private static final String OAUTH2_AUTHORIZATION_CODE = "code";
    private static final String OAUTH2_CLIENT_SECRET = "client_secret";
    private static final String OAUTH2_REDIRECT_URI = "redirect_uri";
    private static final String OAUTH2_GRANT_TYPE = "grant_type";
    private static final String OAUTH2_RESPONSE_TYPE = "response_type";
    private static final String OAUTH2_SCOPE = "scope";
    private static final String OAUTH2_STATE = "state";
    private static final String OAUTH2_TOKEN_ENDPOINT = "/provider/oauth/token";
    private static final String CMS_PORTAL_PAGE = "/portal/";
    private static final String URL_SEPARATOR = "/";
    private static final String QUERY_MARK_SIGN = "?";
    private static final String UTF8_ENCODING = StandardCharsets.UTF_8.name();
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    private static final String DEFAULT_RESPONSE_TYPE = "code";
    private static final String DEFAULT_OAUTH2_SCOPE = "read+write";
    private static final String DEFAULT_OAUTH_CLIENT_ID = "watchpoint";
    private static final String DEFAULT_OAUTH2_CLIENT_SECRET = "secret";
    private static final String DEFAULT_OAUTH2_GRANT_TYPE = "authorization_code";
    private static final String DEFAULT_PROVIDER_VALIDATE_URL = "https://localhost:8443/provider/oauth/validate";
    private static final String DEFAULT_PROVIDER_TOKEN_ENDPOINT_URL = "https://localhost:8443/provider/oauth/token";
    protected String clientId;
    protected String clientSecret;
    protected String providerLoginUri;
    protected String providerLogoutUri;
    protected String providerValidateUrl;
    protected String providerTokenEndpointUrl;
    protected String responseType;
    protected CookieCacheManager cookieCacheManager;
    protected String componentName;
    protected AuthProviderClient providerClient;

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        this.logger.info((Object)"init started...");
        this.clientSecret = config.getInitParameter(NEPTUNE_SSO_OAUTH2_CLIENT_SECRET);
        this.responseType = StringUtils.isBlank((String)config.getInitParameter(NEPTUNE_SSO_OAUTH2_RESPONSE_TYPE)) ? "code" : config.getInitParameter(NEPTUNE_SSO_OAUTH2_RESPONSE_TYPE);
        this.clientId = config.getInitParameter(NEPTUNE_SSO_OAUTH2_CLIENT_ID);
        this.componentName = config.getInitParameter("component_name");
        if (this.componentName == null) {
            this.componentName = DEFAULT_NEPTUNE_COMPONENT_NAME;
        }
        this.providerLoginUri = this.providerUrls.getProperty("neptune_sso_oauth2_provider_login_url");
        if (StringUtils.isBlank((String)this.clientId) || StringUtils.isBlank((String)this.providerLoginUri)) {
            this.logger.error((Object)"SSO Integration can not work properly. Either a neptune_sso_oauth2_client_id is not provided or neptune_sso_oauth2_provider_login_url is not provided");
            throw new ServletException("SSO Integration can not work properly. Either a neptune_sso_oauth2_client_id is not provided or neptune_sso_oauth2_provider_login_url is not provided");
        }
        this.providerValidateUrl = this.providerUrls.getProperty("neptune_sso_oauth2_provider_validate_url");
        if (StringUtils.isBlank((String)this.providerValidateUrl)) {
            this.logger.debug((Object)"neptune_sso_oauth2_provider_validate_url is not set. Set it to the default value: https://watchpoint-app:8443/provider/oauth/validate");
            this.providerValidateUrl = DEFAULT_PROVIDER_VALIDATE_URL;
        }
        this.providerLogoutUri = this.providerUrls.getProperty("neptune_sso_oauth2_provider_logout_url");
        if (StringUtils.isBlank((String)this.providerLogoutUri)) {
            this.providerLogoutUri = "/provider/logout";
            this.logger.debug((Object)("neptune_sso_oauth2_provider_logout_url is not set. Using default value: " + this.providerLogoutUri));
        }
        this.providerTokenEndpointUrl = this.providerUrls.getProperty("neptune_sso_token_endpoint_url", DEFAULT_PROVIDER_TOKEN_ENDPOINT_URL);
        this.providerClient = new AuthProviderClient();
        this.providerClient.setValidateUrl(this.providerValidateUrl);
        this.cookieCacheManager = new CookieCacheManager(this.providerClient, this.isNeptune, this.providerUrls.getProperty("neptune_sso_webservice_url"), this.componentName == null ? DEFAULT_NEPTUNE_COMPONENT_NAME : this.componentName);
        this.logger.info((Object)("SSO Integration configured with neptune_sso_oauth2_provider_login_url of " + this.providerLoginUri + " neptune_sso_oauth2_client_id of " + this.clientId + " neptune_sso_oauth2_provider_validate_url " + this.providerValidateUrl + " neptune_sso_oauth2_provider_logout_url " + this.providerLogoutUri));
    }

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean isGrantCodeRequest;
        this.logger.debug((Object)"Neptune OAuth SSO Filter interrupting the request");
        HttpSession session = request.getSession();
        if (this.isLogoutRequested(request, (ServletResponse)response)) {
            this.logoutSSOUser(request, response);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.cookieCacheManager.storeCookieinCache(request)) {
            return;
        }
        String clientIP = request.getHeader("X-Forwarded-For");
        String remoteAddr = request.getRemoteAddr();
        session.setAttribute("RemoteAddress", (Object)remoteAddr);
        if (clientIP != null) {
            session.setAttribute("X-Forwarded-For", (Object)clientIP);
        }
        boolean bl = isGrantCodeRequest = request.getParameter("code") != null && request.getParameter(OAUTH2_ACCESS_TOKEN) == null;
        if (request.getRequestURI().equals(CMS_PORTAL_PAGE) && isGrantCodeRequest) {
            this.logger.info((Object)"authorize code is found");
            this.tryLoginWithGrantCode(request, response);
            return;
        }
        NeptunePrincipal principal = (NeptunePrincipal)request.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        if (principal == null) {
            principal = (NeptunePrincipal)session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        }
        if (principal == null) {
            String loginToken = request.getParameter(OAUTH2_ACCESS_TOKEN);
            if (Strings.isNullOrEmpty((String)loginToken)) {
                this.logger.debug((Object)"User information not found in session or in request, user is not logged in yet, redirecting to provider login page");
                this.redirectUserToProviderLogin(request, response);
                return;
            }
            this.logger.debug((Object)"Token found in request parameters");
            TokenInfo tokenInfo = this.validateTokenWithProvider(request, response, loginToken);
            if (tokenInfo == null || !tokenInfo.isValid()) {
                this.logger.error((Object)("Invalid token found: " + tokenInfo));
                this.logoutSSOUser(request, response);
                return;
            }
            this.logger.debug((Object)"Login succeeded at provider, caching user info");
            principal = new NeptunePrincipal(tokenInfo, loginToken);
            session.setAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL, (Object)principal);
            String requestUrl = request.getRequestURL().toString();
            requestUrl = requestUrl.substring(0, requestUrl.indexOf(request.getContextPath()));
            session.setAttribute("REST_BASE_URL", (Object)requestUrl);
            session.setAttribute(SESSION_COMPONENT_NAME, (Object)(this.componentName == null ? DEFAULT_NEPTUNE_COMPONENT_NAME : this.componentName));
            this.cookieCacheManager.sendCookieJsonToNeptune(request);
            if (DEFAULT_NEPTUNE_COMPONENT_NAME.equals(this.componentName)) {
                this.logger.debug((Object)this.componentName);
                this.redirectUserToOriginalUrl(request, response);
                return;
            }
        } else {
            this.logger.debug((Object)"Validating SSO Principal to Continue..");
            if (principal.isExpired()) {
                this.logger.debug((Object)"Going to refresh token with provider");
                this.refreshTokenWithProvider(request, response);
                return;
            }
        }
        this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String buildProviderLoginUrl(HttpServletRequest request) {
        String providerLoginUrl = "";
        try {
            providerLoginUrl = this.buildProviderLoginOrLogoutURL(request, true);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        this.logger.debug((Object)("Provider login url is " + providerLoginUrl));
        return providerLoginUrl;
    }

    protected void refreshTokenWithProvider(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logger.debug((Object)"Going to refresh token with provider");
        this.redirectUserToProviderLogin(request, response);
    }

    protected String buildLogoutUrl(HttpServletRequest request) {
        String logoutUrl = "";
        try {
            logoutUrl = this.buildProviderLoginOrLogoutURL(request, false);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        this.logger.debug((Object)("Logout redirection URL is " + logoutUrl));
        return logoutUrl;
    }

    protected TokenInfo validateTokenWithProvider(HttpServletRequest request, HttpServletResponse response, String loginToken) {
        return this.providerClient.validateToken(loginToken, request);
    }

    private void tryLoginWithGrantCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String baseUrl = HttpURLUtil.buildBaseURL(request.getRequestURL().toString());
        this.logger.info((Object)("baserUrl = " + baseUrl));
        if (baseUrl == null) {
            this.logger.error((Object)"Failed to build base url from servlet request");
            this.redirectUserToProviderLogin(request, response);
            return;
        }
        AuthProviderClient client = new AuthProviderClient();
        String tokenUri = this.providerTokenEndpointUrl;
        this.logger.info((Object)("HttpURLUtil.isValidURL(providerTokenEndpointUrl) =" + HttpURLUtil.isValidURL(this.providerTokenEndpointUrl)));
        if (!HttpURLUtil.isValidURL(this.providerTokenEndpointUrl)) {
            tokenUri = baseUrl + OAUTH2_TOKEN_ENDPOINT;
            this.logger.info((Object)("tokenUri =" + tokenUri));
        }
        ImmutableMap parameters = ImmutableMap.of((Object)OAUTH2_GRANT_TYPE, (Object)DEFAULT_OAUTH2_GRANT_TYPE, (Object)OAUTH2_CLIENT_ID, (Object)DEFAULT_OAUTH_CLIENT_ID, (Object)"code", (Object)request.getParameter("code"), (Object)OAUTH2_CLIENT_SECRET, (Object)DEFAULT_OAUTH2_CLIENT_SECRET, (Object)OAUTH2_REDIRECT_URI, (Object)(baseUrl + CMS_PORTAL_PAGE));
        Map<String, Object> accessTokenInfo = client.requestAccessToken(tokenUri, (Map<String, String>)parameters);
        this.logger.info((Object)("accessTokenInfo.containsKey(OAUTH2_ACCESS_TOKEN) =" + accessTokenInfo.containsKey(OAUTH2_ACCESS_TOKEN)));
        if (accessTokenInfo.containsKey(OAUTH2_ACCESS_TOKEN)) {
            String defaultRedirectUrl;
            String accessToken = (String)accessTokenInfo.get(OAUTH2_ACCESS_TOKEN);
            String originalRequestUrl = defaultRedirectUrl = baseUrl + CMS_PORTAL_PAGE;
            this.logger.info((Object)("accessToken =" + accessToken));
            this.logger.info((Object)("defaultRedirectUrl =" + defaultRedirectUrl));
            this.logger.info((Object)("originalRequestUrl =" + originalRequestUrl));
            this.logger.info((Object)("StringUtils.isNotBlank(request.getParameter(OAUTH2_STATE)) =" + StringUtils.isNotBlank((String)request.getParameter(OAUTH2_STATE))));
            if (StringUtils.isNotBlank((String)request.getParameter(OAUTH2_STATE))) {
                String encodedStateParam = request.getParameter(OAUTH2_STATE);
                this.logger.info((Object)("encodedStateParam =" + encodedStateParam));
                originalRequestUrl = OAuth2Util.getCallbackURLFromStateParameter(encodedStateParam, defaultRedirectUrl);
                this.logger.info((Object)("originalRequestUrl =" + originalRequestUrl));
            }
            String redirectUrl = HttpURLUtil.appendParameterToRequestUrl(originalRequestUrl, OAUTH2_ACCESS_TOKEN, accessToken);
            this.logger.info((Object)("redirectUrl =" + redirectUrl));
            if (Strings.isNullOrEmpty((String)redirectUrl)) {
                redirectUrl = String.format("%s?%s=%s", defaultRedirectUrl, OAUTH2_ACCESS_TOKEN, accessToken);
                this.logger.info((Object)("redirectUrl.format =" + redirectUrl));
            }
            this.logger.info((Object)("Access grant successfully, redirecting to " + redirectUrl));
            response.sendRedirect(redirectUrl);
        } else {
            this.logger.warn((Object)"Login failed: cannot issue access token.");
            this.redirectUserToProviderLogin(request, response);
        }
    }

    private void redirectUserToProviderLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectionUrl = this.buildProviderLoginUrl(request);
        response.sendRedirect(redirectionUrl);
    }

    private void redirectUserToOriginalUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestUrl = request.getRequestURL().toString();
        StringBuilder redirectUrlBuilder = new StringBuilder();
        redirectUrlBuilder.append(requestUrl);
        String hashLocation = "";
        if (StringUtils.isNotBlank((String)request.getParameter(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_BOOKMARK))) {
            hashLocation = request.getParameter(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_BOOKMARK);
        }
        Map<String, String> queryParamMap = HttpURLUtil.parseQueryString(request.getQueryString());
        queryParamMap.keySet().removeAll(NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS);
        queryParamMap.keySet().remove(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_BOOKMARK);
        if (!queryParamMap.isEmpty()) {
            redirectUrlBuilder.append(QUERY_MARK_SIGN).append(HttpURLUtil.buildQueryString(queryParamMap));
        }
        if (StringUtils.isNotBlank((String)hashLocation)) {
            redirectUrlBuilder.append("#").append(hashLocation);
        }
        this.logger.debug((Object)("Redirect to " + redirectUrlBuilder.toString()));
        response.sendRedirect(redirectUrlBuilder.toString());
    }

    private void logoutSSOUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        NeptunePrincipal principal;
        this.logger.debug((Object)"Going to log out user from provider");
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        if (this.isNeptune && (principal = (NeptunePrincipal)session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL)) != null) {
            this.cookieCacheManager.sendLogoutRequest(principal.getToken(), session);
        }
        session.removeAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        if (this.isNeptune) {
            response.sendRedirect(this.buildLogoutUrl(request));
        }
    }

    private String buildProviderLoginOrLogoutURL(HttpServletRequest request, boolean isLogin) {
        String providerLogInOutUri;
        StringBuilder originalRequestUrlBuilder = new StringBuilder(request.getRequestURL().toString());
        Map<String, String> queryParamMap = HttpURLUtil.parseQueryString(request.getQueryString());
        this.logger.debug((Object)("original request url path is: " + originalRequestUrlBuilder + " and query params are: " + queryParamMap));
        if (!queryParamMap.isEmpty()) {
            queryParamMap.keySet().removeAll(NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS);
            originalRequestUrlBuilder.append(QUERY_MARK_SIGN).append(HttpURLUtil.buildQueryString(queryParamMap));
        }
        StringBuilder logInOutUrlBuilder = new StringBuilder(32);
        String string = providerLogInOutUri = isLogin ? this.providerLoginUri : this.providerLogoutUri;
        if (!HttpURLUtil.isAbsoluteURL(providerLogInOutUri)) {
            this.logger.debug((Object)("Relative Login/Logout Uri is : " + providerLogInOutUri));
            logInOutUrlBuilder.append(HttpURLUtil.buildBaseURL(request.getRequestURL().toString()));
            if (!providerLogInOutUri.startsWith(URL_SEPARATOR)) {
                logInOutUrlBuilder.append(URL_SEPARATOR);
            }
        }
        logInOutUrlBuilder.append(providerLogInOutUri);
        String queryStr = this.buildOAuth2LoginQueryString(originalRequestUrlBuilder.toString());
        if (StringUtils.isNotBlank((String)queryStr)) {
            logInOutUrlBuilder.append(QUERY_MARK_SIGN).append(queryStr);
        }
        return logInOutUrlBuilder.toString();
    }

    private String buildOAuth2LoginQueryString(String originalRequestUrl) {
        this.logger.debug((Object)("full original request url: " + originalRequestUrl));
        String codeAuthUri = HttpURLUtil.buildBaseURL(originalRequestUrl) + CMS_PORTAL_PAGE;
        HashMap optionalParamMap = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)this.clientId)) {
            optionalParamMap.put(OAUTH2_CLIENT_ID, EncodingUtils.encodeURL(this.clientId, UTF8_ENCODING));
        }
        if (StringUtils.isNotBlank((String)this.clientSecret)) {
            optionalParamMap.put(OAUTH2_CLIENT_SECRET, EncodingUtils.encodeURL(this.clientSecret, UTF8_ENCODING));
        }
        String originalStateParam = Double.toString(Math.random());
        ImmutableMap oauth2LoginParamMap = ImmutableMap.builder().putAll((Map)optionalParamMap).put((Object)OAUTH2_REDIRECT_URI, (Object)EncodingUtils.encodeURL(codeAuthUri, UTF8_ENCODING)).put((Object)OAUTH2_RESPONSE_TYPE, (Object)"code").put((Object)OAUTH2_SCOPE, (Object)DEFAULT_OAUTH2_SCOPE).put((Object)OAUTH2_STATE, (Object)OAuth2Util.encodeStateWithCallbackURL(originalStateParam, originalRequestUrl)).build();
        return HttpURLUtil.buildQueryString((Map<String, String>)oauth2LoginParamMap);
    }

    static {
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(OAUTH2_ACCESS_TOKEN);
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_TOKEN_TYPE);
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add("code");
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_USERNAME);
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(OAUTH2_STATE);
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(NEPTUNE_SSO_OAUTH2_LOGIN_SUCCESS_EXPIRES_IN);
        NEPTUNE_SSO_LOGIN_SUCCESS_PARAMS.add(OAUTH2_CLIENT_ID);
    }
}

