/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.authprovider;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.User;
import com.ericsson.neptune.security.authprovider.TokenInfo;
import com.ericsson.neptune.security.util.EncodingUtils;
import com.ericsson.neptune.security.util.HttpConnUtil;
import com.ericsson.neptune.security.util.HttpURLUtil;
import com.ericsson.neptune.security.util.RestHelper;
import com.ericsson.neptune.security.util.SSLUtil;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class AuthProviderClient {
    private static int CONNECTION_TIMEOUT = 15000;
    private String validateUrl;
    private static final Logger LOG = Logger.getLogger(AuthProviderClient.class);

    public void setValidateUrl(String validateUrl) {
        this.validateUrl = validateUrl;
    }

    public Map<String, Object> requestAccessToken(String tokenUri, Map<String, String> parameters) {
        LOG.debug((Object)("tokenUri =" + tokenUri));
        LOG.info((Object)("FromAuthProviderClient tokenUri =" + tokenUri));
        LOG.info((Object)("parameters =" + parameters));
        Objects.requireNonNull(tokenUri);
        Objects.requireNonNull(parameters);
        String queryStr = HttpURLUtil.buildQueryString(parameters);
        LOG.info((Object)("queryStr =" + queryStr));
        LOG.debug((Object)("queryStr =" + queryStr));
        String requestUri = String.format("%s?%s", tokenUri, queryStr);
        LOG.info((Object)("requestUri =" + requestUri));
        String rawResponse = new RestHelper().makePostRequest(requestUri, null);
        LOG.info((Object)("rawResponse =" + rawResponse));
        Map<String, Object> response = this.convertJsonToMap(rawResponse);
        LOG.info((Object)("response =" + response));
        if (response == null) {
            LOG.warn((Object)("Failed to request access token: " + rawResponse));
            return Collections.emptyMap();
        }
        return response;
    }

    public TokenInfo validateToken(String token, HttpServletRequest originalRequest) {
        LOG.debug((Object)"Validating token with provider");
        if (token == null || token.trim().isEmpty() || originalRequest == null) {
            throw new IllegalArgumentException("Token and original request are required");
        }
        try {
            HttpURLConnection conn = this.makeRequest(this.buildValidateUrl(token), originalRequest.getCookies());
            String validationResponse = this.readRequestResponse(conn);
            LOG.debug((Object)("Response: " + validationResponse));
            if (conn.getResponseCode() == 200 && StringUtils.isNotEmpty((String)validationResponse)) {
                return TokenInfo.parse(validationResponse);
            }
            LOG.warn((Object)("Got invalid response with status " + conn.getResponseCode() + " and response " + validationResponse));
            return null;
        }
        catch (SocketTimeoutException e) {
            LOG.error((Object)"Connection timed out. ", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not validate token with Provider. ", (Throwable)e);
            LOG.debug((Object)e);
            return null;
        }
    }

    public User getUser(String usersWebServiceUrl, HttpServletRequest request, NeptunePrincipal principal) {
        boolean tokenNotNull;
        HashMap<String, String> headers = this.getRequestHeaders(request);
        boolean authoricationHeaderNotExist = !SSLUtil.hasSSLFingerPrint(request) && !this.authorizationHeaderIsPresent(headers);
        boolean bl = tokenNotNull = principal != null && principal.getToken() != null;
        if (authoricationHeaderNotExist && tokenNotNull) {
            headers.put("Authorization", "Bearer " + principal.getToken());
        }
        try {
            HttpURLConnection conn = this.makeUsersRequest(usersWebServiceUrl, headers, SSLUtil.hasSSLFingerPrint(request));
            String validationResponse = this.readRequestResponse(conn);
            if (conn.getResponseCode() != 200 || Strings.isNullOrEmpty((String)validationResponse)) {
                LOG.error((Object)("Got invalid response from neptune with status " + conn.getResponseCode() + " and response " + validationResponse));
                return null;
            }
            Set<User> users = this.parseUsers(validationResponse);
            if (users == null || users.isEmpty()) {
                return null;
            }
            return users.iterator().next();
        }
        catch (Exception e) {
            LOG.error((Object)"Could get roles from neptune. ", (Throwable)e);
            return null;
        }
    }

    private Set<User> parseUsers(String validationResponse) throws IOException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<HashMap<String, Set<User>>> jsonUsersNRoles = new TypeReference<HashMap<String, Set<User>>>(){};
            HashMap userrolemap = (HashMap)mapper.readValue(validationResponse.getBytes(), (TypeReference)jsonUsersNRoles);
            return (Set)userrolemap.get("usersAndRoles");
        }
        catch (Exception e) {
            LOG.error((Object)("Got invalid response: " + validationResponse));
            return Collections.emptySet();
        }
    }

    private boolean authorizationHeaderIsPresent(HashMap<String, String> headers) {
        for (String headerName : headers.keySet()) {
            if (!headerName.equalsIgnoreCase("Authorization")) continue;
            return true;
        }
        return false;
    }

    private HashMap<String, String> getRequestHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                headers.put(headerName, headerValue);
            }
        }
        return headers;
    }

    private HttpURLConnection makeRequest(String requestUri, Cookie[] originalRequestCookies) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        HttpURLConnection conn = HttpConnUtil.openHttpConnection(requestUri);
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "text/plain");
        conn.setConnectTimeout(CONNECTION_TIMEOUT);
        conn.setReadTimeout(CONNECTION_TIMEOUT);
        if (originalRequestCookies != null) {
            for (Cookie cookie : originalRequestCookies) {
                conn.addRequestProperty("Cookie", cookie.getName() + "=" + cookie.getValue());
            }
        }
        conn.connect();
        return conn;
    }

    private String buildValidateUrl(String token) {
        StringBuilder result = new StringBuilder();
        result.append(this.validateUrl);
        result.append("?access_token=");
        result.append(token);
        String validateUri = result.toString();
        LOG.debug((Object)("Provider url: " + validateUri));
        return validateUri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readRequestResponse(HttpURLConnection conn) {
        try (InputStream inputStream = conn.getInputStream();){
            String encoding = EncodingUtils.findResponseEncoding(conn);
            String string = StringUtils.isNotBlank((String)encoding) ? IOUtils.toString((InputStream)inputStream, (String)encoding) : IOUtils.toString((InputStream)inputStream);
            return string;
        }
        catch (IOException e) {
            LOG.warn((Object)"Could not parse validation response", (Throwable)e);
            return "";
        }
    }

    public HttpURLConnection makeUsersRequest(String usersWebServiceUrl, HashMap<String, String> headers, boolean isSSL) throws KeyManagementException, NoSuchAlgorithmException, IOException {
        HttpURLConnection conn = HttpConnUtil.openHttpConnection(usersWebServiceUrl);
        if (isSSL && conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(SSLUtil.getInstance().getSslSocketFactory());
        }
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        conn.connect();
        return conn;
    }

    public String readRequest(HttpServletRequest request) {
        try {
            Map dataMap = request.getParameterMap();
            if (dataMap != null) {
                Iterator itr = dataMap.keySet().iterator();
                String data = (String)itr.next();
                return data;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not parse response", (Throwable)e);
        }
        return "";
    }

    public int logoutUser(String logoutUrl, Cookie[] cookies) {
        try {
            HttpURLConnection conn = this.makeRequest(logoutUrl, cookies);
            return conn.getResponseCode();
        }
        catch (SocketTimeoutException e) {
            LOG.error((Object)"Connection timed out. ", (Throwable)e);
            return -1;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not complete request to remote component. ", (Throwable)e);
            e.printStackTrace();
            return -1;
        }
    }

    public int sendPostRequest(String destination, String postData, Cookie[] cookies) {
        try {
            HttpURLConnection conn = this.postRequest(destination, postData, cookies);
            return conn.getResponseCode();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to post data", (Throwable)e);
            return -1;
        }
    }

    private HttpURLConnection postRequest(String requestUri, String postData, Cookie[] originalRequestCookies) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        byte[] data = postData.getBytes(Charsets.UTF_8);
        HttpURLConnection conn = HttpConnUtil.openHttpConnection(requestUri);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setConnectTimeout(CONNECTION_TIMEOUT);
        conn.setReadTimeout(CONNECTION_TIMEOUT);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", Integer.toString(data.length));
        conn.setUseCaches(false);
        if (originalRequestCookies != null) {
            for (Cookie cookie : originalRequestCookies) {
                conn.addRequestProperty("Cookie", cookie.getName() + "=" + cookie.getValue());
            }
        }
        try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
            wr.writeBytes(postData);
            wr.flush();
        }
        return conn;
    }

    public Map<String, Object> convertJsonToMap(String json) {
        try {
            LOG.info((Object)("json =" + json));
            ObjectMapper jsonMapper = new ObjectMapper();
            return (Map)jsonMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage());
            LOG.debug((Object)e);
            return null;
        }
    }
}

