/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.audit;

import java.util.HashMap;
import java.util.Map;

public abstract class AbstractAuditor<T> {
    public Map<String, String> audit(T oldEntity, T newEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (oldEntity == null && newEntity == null) {
            return map;
        }
        map.put("Entity Type", this.getEntityType());
        if (newEntity == null) {
            map.put("Event Type", "Deleted");
            map.put("Entity Name", this.getEntityName(oldEntity));
            return map;
        }
        if (oldEntity == null) {
            map.put("Event Type", "Created");
        } else {
            map.put("Event Type", "Updated");
        }
        map.put("Entity Name", this.getEntityName(newEntity));
        String changeJson = this.auditEntity(oldEntity, newEntity);
        if (changeJson != null) {
            map.put("Change Json", changeJson);
        }
        return map;
    }

    protected boolean hasStringValueChanged(String oldValue, String newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        return oldValue == null || newValue == null || oldValue.compareTo(newValue) != 0;
    }

    protected abstract String auditEntity(T var1, T var2);

    protected abstract String getEntityType();

    protected abstract String getEntityName(T var1);
}

