/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.StringBaseSettingType;
import com.tandbergtv.neptune.configuration.settings.validator.AbstractSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class StringLengthValidator
extends AbstractSettingValidator {
    @Override
    public ValidationResult validate(SettingDefinition s, String value) {
        StringBaseSettingType setting = (StringBaseSettingType)s;
        ValidationResult result = new ValidationResult();
        if (value != null && !value.trim().isEmpty()) {
            BigInteger max;
            int length = 0;
            length = value.trim().length();
            BigInteger min = setting.getMinimumLength();
            if (min != null && length < min.intValue()) {
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
                params.add(setting.getDisplayName());
                ArrayList<LocalizedString> maxParam = new ArrayList<LocalizedString>(1);
                maxParam.add(new LocalizedString(min.toString(), "en"));
                params.add(maxParam);
                result.fail().addMessage("{0} must be at least {1} characters long.", "en", params);
            }
            if ((max = setting.getMaximumLength()) != null && length > max.intValue()) {
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
                params.add(setting.getDisplayName());
                ArrayList<LocalizedString> maxParam = new ArrayList<LocalizedString>(1);
                maxParam.add(new LocalizedString(max.toString(), "en"));
                params.add(maxParam);
                result.fail().addMessage("{0} should not exceed the {1} characters limit. ", "en", params);
            }
        }
        if (!result.hasFailed()) {
            result.success();
        }
        return result;
    }
}

