/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.ad;

import com.ericsson.neptune.usermgmt.ad.AdPropertiesCache;
import com.sun.jndi.ldap.LdapCtxFactory;
import java.util.Hashtable;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.StringUtils;

public class AdContextFactory {
    private AdPropertiesCache adPropertiesCache;

    @PostConstruct
    public void init() {
        if (this.adPropertiesCache.getProperties() == null || this.adPropertiesCache.getProperties().isEmpty()) {
            throw new IllegalStateException("properties file[/opt/tandbergtv/cms/conf/neptune/ActiveDirectory.properties] not found or empty.");
        }
    }

    public LdapContext createContext() throws NamingException {
        return new InitialLdapContext(this.createEnv(this.adPropertiesCache.getProperties()), new Control[0]);
    }

    public DirContext createContext(String username, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", this.adPropertiesCache.get("ad.url"));
        env.put("java.naming.factory.initial", LdapCtxFactory.class.getName());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.getUserPrincipal(username));
        env.put("java.naming.security.credentials", password);
        return new InitialDirContext(env);
    }

    private String getUserPrincipal(String userName) {
        if (StringUtils.isNotBlank((String)userName)) {
            return userName + "@" + this.adPropertiesCache.get("ad.defaultDomain");
        }
        return userName;
    }

    public Hashtable<String, Object> createEnv(Properties properties) {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        if (properties == null) {
            return env;
        }
        env.put("java.naming.provider.url", properties.getProperty("ad.url"));
        env.put("java.naming.factory.initial", LdapCtxFactory.class.getName());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", properties.getProperty("ad.username") + "@" + properties.getProperty("ad.defaultDomain"));
        env.put("java.naming.security.credentials", properties.getProperty("ad.password"));
        return env;
    }

    public void setAdPropertiesCache(AdPropertiesCache adPropertiesCache) {
        this.adPropertiesCache = adPropertiesCache;
    }
}

