/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ad;

import com.tandbergtv.neptune.usermgmt.external.ad.AbstractActiveDirectoryUserAuthenticationService;
import com.tandbergtv.neptune.usermgmt.external.ad.UserRequestSender;
import java.net.HttpURLConnection;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class ActiveDirectorySyncUserAuthenticationService
extends AbstractActiveDirectoryUserAuthenticationService {
    private static Logger logger = Logger.getLogger(ActiveDirectorySyncUserAuthenticationService.class);
    private UserRequestSender userRequestSender;

    public ActiveDirectorySyncUserAuthenticationService(Properties properties) {
        super(properties);
    }

    @Override
    public void authenticateUser(String userName, String password, String externalKey) throws LoginException {
        this.authenticateAD(userName + "@" + this.getDefaultDomain(), password);
        HttpURLConnection conn = null;
        try {
            conn = this.getUserRequestSender().sendSyncRequest(userName);
            if (conn.getResponseCode() != 200) {
                logger.warn((Object)("fail to sync user, response code[" + conn.getResponseCode()));
                throw new LoginException("error when getting user information");
            }
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"error when getting user information", (Throwable)e);
            throw new LoginException("error when getting user information, " + e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public UserRequestSender getUserRequestSender() {
        if (this.userRequestSender == null) {
            this.userRequestSender = new UserRequestSender();
        }
        return this.userRequestSender;
    }

    public void setUserRequestSender(UserRequestSender userRequestSender) {
        this.userRequestSender = userRequestSender;
    }
}

