/*
 * Created on Dec 30, 2011
 * 
 * (C) Copyright Ericsson Television Inc.
 */

package com.tandbergtv.neptune.ui.realm.client.tab.user.view.external;

import com.tandbergtv.neptune.ui.realm.client.tab.user.model.UiUser;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Record for the external user
 * 
 * @author Vijay Silva
 */
public final class ExternalUserRecord implements Record<String> {

	/* The user managed by the record */
	private final UiUser externalUser;

	/**
	 * Constructor
	 * 
	 * @param user The external user
	 */
	public ExternalUserRecord(UiUser user) {
		this.externalUser = user;
	}

	/**
	 * Get the key for the user
	 * 
	 * @return The external user key
	 */
	@Override
	public String getKey() {
		return externalUser.getExternalKey();
	}

	/**
	 * Get the external user
	 * 
	 * @return The user
	 */
	public UiUser getExternalUser() {
		return this.externalUser;
	}
}
